package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutCapacityAssignmentConfigurationRequest(
    capacityReservationName: CapacityReservationName,
    capacityAssignments: Iterable[zio.aws.athena.model.CapacityAssignment]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest = {
    import PutCapacityAssignmentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest
      .builder()
      .capacityReservationName(
        CapacityReservationName.unwrap(
          capacityReservationName
        ): java.lang.String
      )
      .capacityAssignments(capacityAssignments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest.ReadOnly =
    zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest
      .wrap(buildAwsValue())
}
object PutCapacityAssignmentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest =
      zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest(
        capacityReservationName,
        capacityAssignments.map { item =>
          item.asEditable
        }
      )
    def capacityReservationName: CapacityReservationName
    def capacityAssignments
        : List[zio.aws.athena.model.CapacityAssignment.ReadOnly]
    def getCapacityReservationName: ZIO[Any, Nothing, CapacityReservationName] =
      ZIO.succeed(capacityReservationName)
    def getCapacityAssignments: ZIO[Any, Nothing, List[
      zio.aws.athena.model.CapacityAssignment.ReadOnly
    ]] = ZIO.succeed(capacityAssignments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest
  ) extends zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest.ReadOnly {
    override val capacityReservationName: CapacityReservationName =
      zio.aws.athena.model.primitives
        .CapacityReservationName(impl.capacityReservationName())
    override val capacityAssignments
        : List[zio.aws.athena.model.CapacityAssignment.ReadOnly] = impl
      .capacityAssignments()
      .asScala
      .map { item =>
        zio.aws.athena.model.CapacityAssignment.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest
  ): zio.aws.athena.model.PutCapacityAssignmentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
