package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  SessionManagerToken,
  MaxSessionsCount,
  WorkGroupName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSessionsRequest(
    workGroup: WorkGroupName,
    stateFilter: Optional[zio.aws.athena.model.SessionState] = Optional.Absent,
    maxResults: Optional[MaxSessionsCount] = Optional.Absent,
    nextToken: Optional[SessionManagerToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListSessionsRequest = {
    import ListSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListSessionsRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .optionallyWith(stateFilter.map(value => value.unwrap))(_.stateFilter)
      .optionallyWith(
        maxResults.map(value => MaxSessionsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          SessionManagerToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListSessionsRequest.ReadOnly =
    zio.aws.athena.model.ListSessionsRequest.wrap(buildAwsValue())
}
object ListSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListSessionsRequest =
      zio.aws.athena.model.ListSessionsRequest(
        workGroup,
        stateFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workGroup: WorkGroupName
    def stateFilter: Optional[zio.aws.athena.model.SessionState]
    def maxResults: Optional[MaxSessionsCount]
    def nextToken: Optional[SessionManagerToken]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getStateFilter: ZIO[Any, AwsError, zio.aws.athena.model.SessionState] =
      AwsError.unwrapOptionField("stateFilter", stateFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxSessionsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, SessionManagerToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListSessionsRequest
  ) extends zio.aws.athena.model.ListSessionsRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val stateFilter: Optional[zio.aws.athena.model.SessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateFilter())
        .map(value => zio.aws.athena.model.SessionState.wrap(value))
    override val maxResults: Optional[MaxSessionsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxSessionsCount(value))
    override val nextToken: Optional[SessionManagerToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.athena.model.primitives.SessionManagerToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListSessionsRequest
  ): zio.aws.athena.model.ListSessionsRequest.ReadOnly = new Wrapper(impl)
}
