package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNotebookSessionsResponse(
    notebookSessionsList: Iterable[zio.aws.athena.model.NotebookSessionSummary],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse = {
    import ListNotebookSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse
      .builder()
      .notebookSessionsList(notebookSessionsList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly =
    zio.aws.athena.model.ListNotebookSessionsResponse.wrap(buildAwsValue())
}
object ListNotebookSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNotebookSessionsResponse =
      zio.aws.athena.model.ListNotebookSessionsResponse(
        notebookSessionsList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def notebookSessionsList
        : List[zio.aws.athena.model.NotebookSessionSummary.ReadOnly]
    def nextToken: Optional[Token]
    def getNotebookSessionsList: ZIO[Any, Nothing, List[
      zio.aws.athena.model.NotebookSessionSummary.ReadOnly
    ]] = ZIO.succeed(notebookSessionsList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse
  ) extends zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly {
    override val notebookSessionsList
        : List[zio.aws.athena.model.NotebookSessionSummary.ReadOnly] = impl
      .notebookSessionsList()
      .asScala
      .map { item =>
        zio.aws.athena.model.NotebookSessionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse
  ): zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
