package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNotebookMetadataResponse(
    nextToken: Optional[Token] = Optional.Absent,
    notebookMetadataList: Optional[
      Iterable[zio.aws.athena.model.NotebookMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse = {
    import ListNotebookMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        notebookMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notebookMetadataList)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly =
    zio.aws.athena.model.ListNotebookMetadataResponse.wrap(buildAwsValue())
}
object ListNotebookMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNotebookMetadataResponse =
      zio.aws.athena.model.ListNotebookMetadataResponse(
        nextToken.map(value => value),
        notebookMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def notebookMetadataList
        : Optional[List[zio.aws.athena.model.NotebookMetadata.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNotebookMetadataList: ZIO[Any, AwsError, List[
      zio.aws.athena.model.NotebookMetadata.ReadOnly
    ]] =
      AwsError.unwrapOptionField("notebookMetadataList", notebookMetadataList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse
  ) extends zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val notebookMetadataList
        : Optional[List[zio.aws.athena.model.NotebookMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookMetadataList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.NotebookMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse
  ): zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
