package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  MaxNamedQueriesCount,
  Token
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListNamedQueriesRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxNamedQueriesCount] = Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest = {
    import ListNamedQueriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxNamedQueriesCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly =
    zio.aws.athena.model.ListNamedQueriesRequest.wrap(buildAwsValue())
}
object ListNamedQueriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNamedQueriesRequest =
      zio.aws.athena.model.ListNamedQueriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workGroup.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxNamedQueriesCount]
    def workGroup: Optional[WorkGroupName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxNamedQueriesCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ) extends zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxNamedQueriesCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxNamedQueriesCount(value)
        )
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ): zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly = new Wrapper(impl)
}
