package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  SessionManagerToken,
  MaxListExecutorsCount,
  SessionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExecutorsRequest(
    sessionId: SessionId,
    executorStateFilter: Optional[zio.aws.athena.model.ExecutorState] =
      Optional.Absent,
    maxResults: Optional[MaxListExecutorsCount] = Optional.Absent,
    nextToken: Optional[SessionManagerToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListExecutorsRequest = {
    import ListExecutorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListExecutorsRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(executorStateFilter.map(value => value.unwrap))(
        _.executorStateFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxListExecutorsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          SessionManagerToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListExecutorsRequest.ReadOnly =
    zio.aws.athena.model.ListExecutorsRequest.wrap(buildAwsValue())
}
object ListExecutorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListExecutorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListExecutorsRequest =
      zio.aws.athena.model.ListExecutorsRequest(
        sessionId,
        executorStateFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sessionId: SessionId
    def executorStateFilter: Optional[zio.aws.athena.model.ExecutorState]
    def maxResults: Optional[MaxListExecutorsCount]
    def nextToken: Optional[SessionManagerToken]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getExecutorStateFilter
        : ZIO[Any, AwsError, zio.aws.athena.model.ExecutorState] =
      AwsError.unwrapOptionField("executorStateFilter", executorStateFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxListExecutorsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, SessionManagerToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListExecutorsRequest
  ) extends zio.aws.athena.model.ListExecutorsRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
    override val executorStateFilter
        : Optional[zio.aws.athena.model.ExecutorState] = zio.aws.core.internal
      .optionalFromNullable(impl.executorStateFilter())
      .map(value => zio.aws.athena.model.ExecutorState.wrap(value))
    override val maxResults: Optional[MaxListExecutorsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxListExecutorsCount(value)
        )
    override val nextToken: Optional[SessionManagerToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.athena.model.primitives.SessionManagerToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListExecutorsRequest
  ): zio.aws.athena.model.ListExecutorsRequest.ReadOnly = new Wrapper(impl)
}
