package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCapacityReservationsResponse(
    nextToken: Optional[Token] = Optional.Absent,
    capacityReservations: Iterable[zio.aws.athena.model.CapacityReservation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse = {
    import ListCapacityReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .capacityReservations(capacityReservations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.ListCapacityReservationsResponse.ReadOnly =
    zio.aws.athena.model.ListCapacityReservationsResponse.wrap(buildAwsValue())
}
object ListCapacityReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListCapacityReservationsResponse =
      zio.aws.athena.model.ListCapacityReservationsResponse(
        nextToken.map(value => value),
        capacityReservations.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[Token]
    def capacityReservations
        : List[zio.aws.athena.model.CapacityReservation.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCapacityReservations: ZIO[Any, Nothing, List[
      zio.aws.athena.model.CapacityReservation.ReadOnly
    ]] = ZIO.succeed(capacityReservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse
  ) extends zio.aws.athena.model.ListCapacityReservationsResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val capacityReservations
        : List[zio.aws.athena.model.CapacityReservation.ReadOnly] = impl
      .capacityReservations()
      .asScala
      .map { item =>
        zio.aws.athena.model.CapacityReservation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse
  ): zio.aws.athena.model.ListCapacityReservationsResponse.ReadOnly =
    new Wrapper(impl)
}
