package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListApplicationDpuSizesResponse(
    applicationDPUSizes: Optional[
      Iterable[zio.aws.athena.model.ApplicationDPUSizes]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse = {
    import ListApplicationDpuSizesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse
      .builder()
      .optionallyWith(
        applicationDPUSizes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationDPUSizes)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly =
    zio.aws.athena.model.ListApplicationDpuSizesResponse.wrap(buildAwsValue())
}
object ListApplicationDpuSizesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListApplicationDpuSizesResponse =
      zio.aws.athena.model.ListApplicationDpuSizesResponse(
        applicationDPUSizes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationDPUSizes
        : Optional[List[zio.aws.athena.model.ApplicationDPUSizes.ReadOnly]]
    def nextToken: Optional[Token]
    def getApplicationDPUSizes: ZIO[Any, AwsError, List[
      zio.aws.athena.model.ApplicationDPUSizes.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationDPUSizes", applicationDPUSizes)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse
  ) extends zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly {
    override val applicationDPUSizes
        : Optional[List[zio.aws.athena.model.ApplicationDPUSizes.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDPUSizes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.ApplicationDPUSizes.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse
  ): zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly =
    new Wrapper(impl)
}
