package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCapacityAssignmentConfigurationRequest(
    capacityReservationName: CapacityReservationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest = {
    import GetCapacityAssignmentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest
      .builder()
      .capacityReservationName(
        CapacityReservationName.unwrap(
          capacityReservationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCapacityAssignmentConfigurationRequest.ReadOnly =
    zio.aws.athena.model.GetCapacityAssignmentConfigurationRequest
      .wrap(buildAwsValue())
}
object GetCapacityAssignmentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.athena.model.GetCapacityAssignmentConfigurationRequest =
      zio.aws.athena.model
        .GetCapacityAssignmentConfigurationRequest(capacityReservationName)
    def capacityReservationName: CapacityReservationName
    def getCapacityReservationName: ZIO[Any, Nothing, CapacityReservationName] =
      ZIO.succeed(capacityReservationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest
  ) extends zio.aws.athena.model.GetCapacityAssignmentConfigurationRequest.ReadOnly {
    override val capacityReservationName: CapacityReservationName =
      zio.aws.athena.model.primitives
        .CapacityReservationName(impl.capacityReservationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest
  ): zio.aws.athena.model.GetCapacityAssignmentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
