package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportNotebookRequest(notebookId: NotebookId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ExportNotebookRequest = {
    import ExportNotebookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ExportNotebookRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ExportNotebookRequest.ReadOnly =
    zio.aws.athena.model.ExportNotebookRequest.wrap(buildAwsValue())
}
object ExportNotebookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ExportNotebookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ExportNotebookRequest =
      zio.aws.athena.model.ExportNotebookRequest(notebookId)
    def notebookId: NotebookId
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ExportNotebookRequest
  ) extends zio.aws.athena.model.ExportNotebookRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ExportNotebookRequest
  ): zio.aws.athena.model.ExportNotebookRequest.ReadOnly = new Wrapper(impl)
}
