package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait CapacityAllocationStatus {
  def unwrap
      : software.amazon.awssdk.services.athena.model.CapacityAllocationStatus
}
object CapacityAllocationStatus {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.CapacityAllocationStatus
  ): zio.aws.athena.model.CapacityAllocationStatus = value match {
    case software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.athena.model.CapacityAllocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityAllocationStatus =
      software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.athena.model.CapacityAllocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityAllocationStatus =
      software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.PENDING
  }
  case object SUCCEEDED extends zio.aws.athena.model.CapacityAllocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityAllocationStatus =
      software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.athena.model.CapacityAllocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityAllocationStatus =
      software.amazon.awssdk.services.athena.model.CapacityAllocationStatus.FAILED
  }
}
