package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class CapacityAllocation(
    status: zio.aws.athena.model.CapacityAllocationStatus,
    statusMessage: Optional[String] = Optional.Absent,
    requestTime: Timestamp,
    requestCompletionTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CapacityAllocation = {
    import CapacityAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CapacityAllocation
      .builder()
      .status(status.unwrap)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .requestTime(Timestamp.unwrap(requestTime): Instant)
      .optionallyWith(
        requestCompletionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.requestCompletionTime)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CapacityAllocation.ReadOnly =
    zio.aws.athena.model.CapacityAllocation.wrap(buildAwsValue())
}
object CapacityAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CapacityAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CapacityAllocation =
      zio.aws.athena.model.CapacityAllocation(
        status,
        statusMessage.map(value => value),
        requestTime,
        requestCompletionTime.map(value => value)
      )
    def status: zio.aws.athena.model.CapacityAllocationStatus
    def statusMessage: Optional[String]
    def requestTime: Timestamp
    def requestCompletionTime: Optional[Timestamp]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.athena.model.CapacityAllocationStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getRequestTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(requestTime)
    def getRequestCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestCompletionTime", requestCompletionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CapacityAllocation
  ) extends zio.aws.athena.model.CapacityAllocation.ReadOnly {
    override val status: zio.aws.athena.model.CapacityAllocationStatus =
      zio.aws.athena.model.CapacityAllocationStatus.wrap(impl.status())
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val requestTime: Timestamp =
      zio.aws.athena.model.primitives.Timestamp(impl.requestTime())
    override val requestCompletionTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCompletionTime())
        .map(value => zio.aws.athena.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CapacityAllocation
  ): zio.aws.athena.model.CapacityAllocation.ReadOnly = new Wrapper(impl)
}
