package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelCapacityReservationRequest(
    name: CapacityReservationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest = {
    import CancelCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest
      .builder()
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CancelCapacityReservationRequest.ReadOnly =
    zio.aws.athena.model.CancelCapacityReservationRequest.wrap(buildAwsValue())
}
object CancelCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CancelCapacityReservationRequest =
      zio.aws.athena.model.CancelCapacityReservationRequest(name)
    def name: CapacityReservationName
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest
  ) extends zio.aws.athena.model.CancelCapacityReservationRequest.ReadOnly {
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest
  ): zio.aws.athena.model.CancelCapacityReservationRequest.ReadOnly =
    new Wrapper(impl)
}
