package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetPreparedStatementResponse(
    preparedStatements: Optional[
      Iterable[zio.aws.athena.model.PreparedStatement]
    ] = Optional.Absent,
    unprocessedPreparedStatementNames: Optional[
      Iterable[zio.aws.athena.model.UnprocessedPreparedStatementName]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse = {
    import BatchGetPreparedStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse
      .builder()
      .optionallyWith(
        preparedStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.preparedStatements)
      .optionallyWith(
        unprocessedPreparedStatementNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedPreparedStatementNames)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly =
    zio.aws.athena.model.BatchGetPreparedStatementResponse.wrap(buildAwsValue())
}
object BatchGetPreparedStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetPreparedStatementResponse =
      zio.aws.athena.model.BatchGetPreparedStatementResponse(
        preparedStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedPreparedStatementNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def preparedStatements
        : Optional[List[zio.aws.athena.model.PreparedStatement.ReadOnly]]
    def unprocessedPreparedStatementNames: Optional[
      List[zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly]
    ]
    def getPreparedStatements: ZIO[Any, AwsError, List[
      zio.aws.athena.model.PreparedStatement.ReadOnly
    ]] = AwsError.unwrapOptionField("preparedStatements", preparedStatements)
    def getUnprocessedPreparedStatementNames: ZIO[Any, AwsError, List[
      zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedPreparedStatementNames",
      unprocessedPreparedStatementNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse
  ) extends zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly {
    override val preparedStatements
        : Optional[List[zio.aws.athena.model.PreparedStatement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preparedStatements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.PreparedStatement.wrap(item)
          }.toList
        )
    override val unprocessedPreparedStatementNames: Optional[
      List[zio.aws.athena.model.UnprocessedPreparedStatementName.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedPreparedStatementNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.UnprocessedPreparedStatementName.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse
  ): zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly =
    new Wrapper(impl)
}
