package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  Timestamp,
  KeyString,
  ParametersMapValue,
  NameString,
  TableTypeString
}
import scala.jdk.CollectionConverters.*
final case class TableMetadata(
    name: NameString,
    createTime: Optional[Timestamp] = Optional.Absent,
    lastAccessTime: Optional[Timestamp] = Optional.Absent,
    tableType: Optional[TableTypeString] = Optional.Absent,
    columns: Optional[Iterable[zio.aws.athena.model.Column]] = Optional.Absent,
    partitionKeys: Optional[Iterable[zio.aws.athena.model.Column]] =
      Optional.Absent,
    parameters: Optional[Map[KeyString, ParametersMapValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.TableMetadata = {
    import TableMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.TableMetadata
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        lastAccessTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastAccessTime)
      .optionallyWith(
        tableType.map(value => TableTypeString.unwrap(value): java.lang.String)
      )(_.tableType)
      .optionallyWith(
        columns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columns)
      .optionallyWith(
        partitionKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partitionKeys)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.TableMetadata.ReadOnly =
    zio.aws.athena.model.TableMetadata.wrap(buildAwsValue())
}
object TableMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.TableMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.TableMetadata =
      zio.aws.athena.model.TableMetadata(
        name,
        createTime.map(value => value),
        lastAccessTime.map(value => value),
        tableType.map(value => value),
        columns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        partitionKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameters.map(value => value)
      )
    def name: NameString
    def createTime: Optional[Timestamp]
    def lastAccessTime: Optional[Timestamp]
    def tableType: Optional[TableTypeString]
    def columns: Optional[List[zio.aws.athena.model.Column.ReadOnly]]
    def partitionKeys: Optional[List[zio.aws.athena.model.Column.ReadOnly]]
    def parameters: Optional[Map[KeyString, ParametersMapValue]]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastAccessTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastAccessTime", lastAccessTime)
    def getTableType: ZIO[Any, AwsError, TableTypeString] =
      AwsError.unwrapOptionField("tableType", tableType)
    def getColumns
        : ZIO[Any, AwsError, List[zio.aws.athena.model.Column.ReadOnly]] =
      AwsError.unwrapOptionField("columns", columns)
    def getPartitionKeys
        : ZIO[Any, AwsError, List[zio.aws.athena.model.Column.ReadOnly]] =
      AwsError.unwrapOptionField("partitionKeys", partitionKeys)
    def getParameters: ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.TableMetadata
  ) extends zio.aws.athena.model.TableMetadata.ReadOnly {
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val createTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.athena.model.primitives.Timestamp(value))
    override val lastAccessTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAccessTime())
      .map(value => zio.aws.athena.model.primitives.Timestamp(value))
    override val tableType: Optional[TableTypeString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableType())
      .map(value => zio.aws.athena.model.primitives.TableTypeString(value))
    override val columns: Optional[List[zio.aws.athena.model.Column.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Column.wrap(item)
          }.toList
        )
    override val partitionKeys
        : Optional[List[zio.aws.athena.model.Column.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Column.wrap(item)
          }.toList
        )
    override val parameters: Optional[Map[KeyString, ParametersMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.athena.model.primitives.KeyString(
                key
              ) -> zio.aws.athena.model.primitives.ParametersMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.TableMetadata
  ): zio.aws.athena.model.TableMetadata.ReadOnly = new Wrapper(impl)
}
