package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartSessionResponse(
    sessionId: Optional[SessionId] = Optional.Absent,
    state: Optional[zio.aws.athena.model.SessionState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartSessionResponse = {
    import StartSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StartSessionResponse.ReadOnly =
    zio.aws.athena.model.StartSessionResponse.wrap(buildAwsValue())
}
object StartSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartSessionResponse =
      zio.aws.athena.model.StartSessionResponse(
        sessionId.map(value => value),
        state.map(value => value)
      )
    def sessionId: Optional[SessionId]
    def state: Optional[zio.aws.athena.model.SessionState]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.SessionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartSessionResponse
  ) extends zio.aws.athena.model.StartSessionResponse.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val state: Optional[zio.aws.athena.model.SessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.athena.model.SessionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartSessionResponse
  ): zio.aws.athena.model.StartSessionResponse.ReadOnly = new Wrapper(impl)
}
