package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{MaxCapacityReservationsCount, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCapacityReservationsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxCapacityReservationsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest = {
    import ListCapacityReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxCapacityReservationsCount.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.ListCapacityReservationsRequest.ReadOnly =
    zio.aws.athena.model.ListCapacityReservationsRequest.wrap(buildAwsValue())
}
object ListCapacityReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListCapacityReservationsRequest =
      zio.aws.athena.model.ListCapacityReservationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxCapacityReservationsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxCapacityReservationsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest
  ) extends zio.aws.athena.model.ListCapacityReservationsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxCapacityReservationsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxCapacityReservationsCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest
  ): zio.aws.athena.model.ListCapacityReservationsRequest.ReadOnly =
    new Wrapper(impl)
}
