package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  NameString,
  WorkGroupName,
  DescriptionString,
  SessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSessionResponse(
    sessionId: Optional[SessionId] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent,
    engineVersion: Optional[NameString] = Optional.Absent,
    engineConfiguration: Optional[zio.aws.athena.model.EngineConfiguration] =
      Optional.Absent,
    notebookVersion: Optional[NameString] = Optional.Absent,
    sessionConfiguration: Optional[zio.aws.athena.model.SessionConfiguration] =
      Optional.Absent,
    status: Optional[zio.aws.athena.model.SessionStatus] = Optional.Absent,
    statistics: Optional[zio.aws.athena.model.SessionStatistics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .optionallyWith(
        engineVersion.map(value => NameString.unwrap(value): java.lang.String)
      )(_.engineVersion)
      .optionallyWith(engineConfiguration.map(value => value.buildAwsValue()))(
        _.engineConfiguration
      )
      .optionallyWith(
        notebookVersion.map(value => NameString.unwrap(value): java.lang.String)
      )(_.notebookVersion)
      .optionallyWith(sessionConfiguration.map(value => value.buildAwsValue()))(
        _.sessionConfiguration
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetSessionResponse.ReadOnly =
    zio.aws.athena.model.GetSessionResponse.wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetSessionResponse =
      zio.aws.athena.model.GetSessionResponse(
        sessionId.map(value => value),
        description.map(value => value),
        workGroup.map(value => value),
        engineVersion.map(value => value),
        engineConfiguration.map(value => value.asEditable),
        notebookVersion.map(value => value),
        sessionConfiguration.map(value => value.asEditable),
        status.map(value => value.asEditable),
        statistics.map(value => value.asEditable)
      )
    def sessionId: Optional[SessionId]
    def description: Optional[DescriptionString]
    def workGroup: Optional[WorkGroupName]
    def engineVersion: Optional[NameString]
    def engineConfiguration
        : Optional[zio.aws.athena.model.EngineConfiguration.ReadOnly]
    def notebookVersion: Optional[NameString]
    def sessionConfiguration
        : Optional[zio.aws.athena.model.SessionConfiguration.ReadOnly]
    def status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly]
    def statistics: Optional[zio.aws.athena.model.SessionStatistics.ReadOnly]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getEngineVersion: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EngineConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("engineConfiguration", engineConfiguration)
    def getNotebookVersion: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("notebookVersion", notebookVersion)
    def getSessionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.SessionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sessionConfiguration", sessionConfiguration)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.SessionStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.athena.model.SessionStatistics.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetSessionResponse
  ) extends zio.aws.athena.model.GetSessionResponse.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val engineVersion: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val engineConfiguration
        : Optional[zio.aws.athena.model.EngineConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineConfiguration())
        .map(value => zio.aws.athena.model.EngineConfiguration.wrap(value))
    override val notebookVersion: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookVersion())
      .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val sessionConfiguration
        : Optional[zio.aws.athena.model.SessionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionConfiguration())
        .map(value => zio.aws.athena.model.SessionConfiguration.wrap(value))
    override val status: Optional[zio.aws.athena.model.SessionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.SessionStatus.wrap(value))
    override val statistics
        : Optional[zio.aws.athena.model.SessionStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.athena.model.SessionStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetSessionResponse
  ): zio.aws.athena.model.GetSessionResponse.ReadOnly = new Wrapper(impl)
}
