package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCapacityReservationResponse(
    capacityReservation: zio.aws.athena.model.CapacityReservation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse = {
    import GetCapacityReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse
      .builder()
      .capacityReservation(capacityReservation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly =
    zio.aws.athena.model.GetCapacityReservationResponse.wrap(buildAwsValue())
}
object GetCapacityReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCapacityReservationResponse =
      zio.aws.athena.model
        .GetCapacityReservationResponse(capacityReservation.asEditable)
    def capacityReservation: zio.aws.athena.model.CapacityReservation.ReadOnly
    def getCapacityReservation
        : ZIO[Any, Nothing, zio.aws.athena.model.CapacityReservation.ReadOnly] =
      ZIO.succeed(capacityReservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse
  ) extends zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly {
    override val capacityReservation
        : zio.aws.athena.model.CapacityReservation.ReadOnly =
      zio.aws.athena.model.CapacityReservation.wrap(impl.capacityReservation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse
  ): zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
