package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  Timestamp,
  AllocatedDpusInteger,
  TargetDpusInteger,
  CapacityReservationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CapacityReservation(
    name: CapacityReservationName,
    status: zio.aws.athena.model.CapacityReservationStatus,
    targetDpus: TargetDpusInteger,
    allocatedDpus: AllocatedDpusInteger,
    lastAllocation: Optional[zio.aws.athena.model.CapacityAllocation] =
      Optional.Absent,
    lastSuccessfulAllocationTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CapacityReservation = {
    import CapacityReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CapacityReservation
      .builder()
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .targetDpus(TargetDpusInteger.unwrap(targetDpus): Integer)
      .allocatedDpus(AllocatedDpusInteger.unwrap(allocatedDpus): Integer)
      .optionallyWith(lastAllocation.map(value => value.buildAwsValue()))(
        _.lastAllocation
      )
      .optionallyWith(
        lastSuccessfulAllocationTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastSuccessfulAllocationTime)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CapacityReservation.ReadOnly =
    zio.aws.athena.model.CapacityReservation.wrap(buildAwsValue())
}
object CapacityReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CapacityReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CapacityReservation =
      zio.aws.athena.model.CapacityReservation(
        name,
        status,
        targetDpus,
        allocatedDpus,
        lastAllocation.map(value => value.asEditable),
        lastSuccessfulAllocationTime.map(value => value),
        creationTime
      )
    def name: CapacityReservationName
    def status: zio.aws.athena.model.CapacityReservationStatus
    def targetDpus: TargetDpusInteger
    def allocatedDpus: AllocatedDpusInteger
    def lastAllocation
        : Optional[zio.aws.athena.model.CapacityAllocation.ReadOnly]
    def lastSuccessfulAllocationTime: Optional[Timestamp]
    def creationTime: Timestamp
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.athena.model.CapacityReservationStatus] =
      ZIO.succeed(status)
    def getTargetDpus: ZIO[Any, Nothing, TargetDpusInteger] =
      ZIO.succeed(targetDpus)
    def getAllocatedDpus: ZIO[Any, Nothing, AllocatedDpusInteger] =
      ZIO.succeed(allocatedDpus)
    def getLastAllocation
        : ZIO[Any, AwsError, zio.aws.athena.model.CapacityAllocation.ReadOnly] =
      AwsError.unwrapOptionField("lastAllocation", lastAllocation)
    def getLastSuccessfulAllocationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastSuccessfulAllocationTime",
        lastSuccessfulAllocationTime
      )
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CapacityReservation
  ) extends zio.aws.athena.model.CapacityReservation.ReadOnly {
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
    override val status: zio.aws.athena.model.CapacityReservationStatus =
      zio.aws.athena.model.CapacityReservationStatus.wrap(impl.status())
    override val targetDpus: TargetDpusInteger =
      zio.aws.athena.model.primitives.TargetDpusInteger(impl.targetDpus())
    override val allocatedDpus: AllocatedDpusInteger =
      zio.aws.athena.model.primitives.AllocatedDpusInteger(impl.allocatedDpus())
    override val lastAllocation
        : Optional[zio.aws.athena.model.CapacityAllocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAllocation())
        .map(value => zio.aws.athena.model.CapacityAllocation.wrap(value))
    override val lastSuccessfulAllocationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulAllocationTime())
        .map(value => zio.aws.athena.model.primitives.Timestamp(value))
    override val creationTime: Timestamp =
      zio.aws.athena.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CapacityReservation
  ): zio.aws.athena.model.CapacityReservation.ReadOnly = new Wrapper(impl)
}
