package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  Date,
  WorkGroupDescriptionString,
  WorkGroupName
}
import scala.jdk.CollectionConverters.*
final case class WorkGroup(
    name: WorkGroupName,
    state: Optional[zio.aws.athena.model.WorkGroupState] = Optional.Absent,
    configuration: Optional[zio.aws.athena.model.WorkGroupConfiguration] =
      Optional.Absent,
    description: Optional[WorkGroupDescriptionString] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroup = {
    import WorkGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroup
      .builder()
      .name(WorkGroupName.unwrap(name): java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value =>
          WorkGroupDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroup.ReadOnly =
    zio.aws.athena.model.WorkGroup.wrap(buildAwsValue())
}
object WorkGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.WorkGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroup =
      zio.aws.athena.model.WorkGroup(
        name,
        state.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        creationTime.map(value => value)
      )
    def name: WorkGroupName
    def state: Optional[zio.aws.athena.model.WorkGroupState]
    def configuration
        : Optional[zio.aws.athena.model.WorkGroupConfiguration.ReadOnly]
    def description: Optional[WorkGroupDescriptionString]
    def creationTime: Optional[Date]
    def getName: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(name)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.WorkGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.WorkGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, WorkGroupDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroup
  ) extends zio.aws.athena.model.WorkGroup.ReadOnly {
    override val name: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.name())
    override val state: Optional[zio.aws.athena.model.WorkGroupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.athena.model.WorkGroupState.wrap(value))
    override val configuration
        : Optional[zio.aws.athena.model.WorkGroupConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.athena.model.WorkGroupConfiguration.wrap(value))
    override val description: Optional[WorkGroupDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.athena.model.primitives.WorkGroupDescriptionString(value)
        )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroup
  ): zio.aws.athena.model.WorkGroup.ReadOnly = new Wrapper(impl)
}
