package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ClientRequestToken,
  SessionId,
  Payload,
  NotebookId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNotebookRequest(
    notebookId: NotebookId,
    payload: Payload,
    `type`: zio.aws.athena.model.NotebookType,
    sessionId: Optional[SessionId] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateNotebookRequest = {
    import UpdateNotebookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateNotebookRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .payload(Payload.unwrap(payload): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdateNotebookRequest.ReadOnly =
    zio.aws.athena.model.UpdateNotebookRequest.wrap(buildAwsValue())
}
object UpdateNotebookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateNotebookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateNotebookRequest =
      zio.aws.athena.model.UpdateNotebookRequest(
        notebookId,
        payload,
        `type`,
        sessionId.map(value => value),
        clientRequestToken.map(value => value)
      )
    def notebookId: NotebookId
    def payload: Payload
    def `type`: zio.aws.athena.model.NotebookType
    def sessionId: Optional[SessionId]
    def clientRequestToken: Optional[ClientRequestToken]
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
    def getPayload: ZIO[Any, Nothing, Payload] = ZIO.succeed(payload)
    def getType: ZIO[Any, Nothing, zio.aws.athena.model.NotebookType] =
      ZIO.succeed(`type`)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateNotebookRequest
  ) extends zio.aws.athena.model.UpdateNotebookRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
    override val payload: Payload =
      zio.aws.athena.model.primitives.Payload(impl.payload())
    override val `type`: zio.aws.athena.model.NotebookType =
      zio.aws.athena.model.NotebookType.wrap(impl.`type`())
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateNotebookRequest
  ): zio.aws.athena.model.UpdateNotebookRequest.ReadOnly = new Wrapper(impl)
}
