package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopCalculationExecutionResponse(
    state: Optional[zio.aws.athena.model.CalculationExecutionState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse = {
    import StopCalculationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly =
    zio.aws.athena.model.StopCalculationExecutionResponse.wrap(buildAwsValue())
}
object StopCalculationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StopCalculationExecutionResponse =
      zio.aws.athena.model
        .StopCalculationExecutionResponse(state.map(value => value))
    def state: Optional[zio.aws.athena.model.CalculationExecutionState]
    def getState
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationExecutionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse
  ) extends zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly {
    override val state
        : Optional[zio.aws.athena.model.CalculationExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.athena.model.CalculationExecutionState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse
  ): zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
