package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ExecutionParameter,
  WorkGroupName,
  IdempotencyToken,
  QueryString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartQueryExecutionRequest(
    queryString: QueryString,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    queryExecutionContext: Optional[
      zio.aws.athena.model.QueryExecutionContext
    ] = Optional.Absent,
    resultConfiguration: Optional[zio.aws.athena.model.ResultConfiguration] =
      Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent,
    executionParameters: Optional[Iterable[ExecutionParameter]] =
      Optional.Absent,
    resultReuseConfiguration: Optional[
      zio.aws.athena.model.ResultReuseConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest = {
    import StartQueryExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        queryExecutionContext.map(value => value.buildAwsValue())
      )(_.queryExecutionContext)
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .optionallyWith(
        executionParameters.map(value =>
          value.map { item =>
            ExecutionParameter.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.executionParameters)
      .optionallyWith(
        resultReuseConfiguration.map(value => value.buildAwsValue())
      )(_.resultReuseConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly =
    zio.aws.athena.model.StartQueryExecutionRequest.wrap(buildAwsValue())
}
object StartQueryExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartQueryExecutionRequest =
      zio.aws.athena.model.StartQueryExecutionRequest(
        queryString,
        clientRequestToken.map(value => value),
        queryExecutionContext.map(value => value.asEditable),
        resultConfiguration.map(value => value.asEditable),
        workGroup.map(value => value),
        executionParameters.map(value => value),
        resultReuseConfiguration.map(value => value.asEditable)
      )
    def queryString: QueryString
    def clientRequestToken: Optional[IdempotencyToken]
    def queryExecutionContext
        : Optional[zio.aws.athena.model.QueryExecutionContext.ReadOnly]
    def resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def workGroup: Optional[WorkGroupName]
    def executionParameters: Optional[List[ExecutionParameter]]
    def resultReuseConfiguration
        : Optional[zio.aws.athena.model.ResultReuseConfiguration.ReadOnly]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getQueryExecutionContext: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionContext.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryExecutionContext", queryExecutionContext)
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getExecutionParameters: ZIO[Any, AwsError, List[ExecutionParameter]] =
      AwsError.unwrapOptionField("executionParameters", executionParameters)
    def getResultReuseConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultReuseConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resultReuseConfiguration",
      resultReuseConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ) extends zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly {
    override val queryString: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryString())
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.IdempotencyToken(value))
    override val queryExecutionContext
        : Optional[zio.aws.athena.model.QueryExecutionContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryExecutionContext())
        .map(value => zio.aws.athena.model.QueryExecutionContext.wrap(value))
    override val resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultConfiguration())
        .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val executionParameters: Optional[List[ExecutionParameter]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.primitives.ExecutionParameter(item)
          }.toList
        )
    override val resultReuseConfiguration
        : Optional[zio.aws.athena.model.ResultReuseConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultReuseConfiguration())
        .map(value => zio.aws.athena.model.ResultReuseConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ): zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
