package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryStagePlanNode(
    name: Optional[String] = Optional.Absent,
    identifier: Optional[String] = Optional.Absent,
    children: Optional[Iterable[zio.aws.athena.model.QueryStagePlanNode]] =
      Optional.Absent,
    remoteSources: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryStagePlanNode = {
    import QueryStagePlanNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryStagePlanNode
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(
        remoteSources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.remoteSources)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryStagePlanNode.ReadOnly =
    zio.aws.athena.model.QueryStagePlanNode.wrap(buildAwsValue())
}
object QueryStagePlanNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryStagePlanNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryStagePlanNode =
      zio.aws.athena.model.QueryStagePlanNode(
        name.map(value => value),
        identifier.map(value => value),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remoteSources.map(value => value)
      )
    def name: Optional[String]
    def identifier: Optional[String]
    def children
        : Optional[List[zio.aws.athena.model.QueryStagePlanNode.ReadOnly]]
    def remoteSources: Optional[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.athena.model.QueryStagePlanNode.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getRemoteSources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("remoteSources", remoteSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryStagePlanNode
  ) extends zio.aws.athena.model.QueryStagePlanNode.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val identifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => value: String)
    override val children
        : Optional[List[zio.aws.athena.model.QueryStagePlanNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.QueryStagePlanNode.wrap(item)
          }.toList
        )
    override val remoteSources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteSources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryStagePlanNode
  ): zio.aws.athena.model.QueryStagePlanNode.ReadOnly = new Wrapper(impl)
}
