package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{Date, SessionId}
import scala.jdk.CollectionConverters.*
final case class NotebookSessionSummary(
    sessionId: Optional[SessionId] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.NotebookSessionSummary = {
    import NotebookSessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.NotebookSessionSummary
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.NotebookSessionSummary.ReadOnly =
    zio.aws.athena.model.NotebookSessionSummary.wrap(buildAwsValue())
}
object NotebookSessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.NotebookSessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.NotebookSessionSummary =
      zio.aws.athena.model.NotebookSessionSummary(
        sessionId.map(value => value),
        creationTime.map(value => value)
      )
    def sessionId: Optional[SessionId]
    def creationTime: Optional[Date]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.NotebookSessionSummary
  ) extends zio.aws.athena.model.NotebookSessionSummary.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.NotebookSessionSummary
  ): zio.aws.athena.model.NotebookSessionSummary.ReadOnly = new Wrapper(impl)
}
