package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{WorkGroupName, MaxNotebooksCount, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListNotebookMetadataRequest(
    filters: Optional[zio.aws.athena.model.FilterDefinition] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxNotebooksCount] = Optional.Absent,
    workGroup: WorkGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest = {
    import ListNotebookMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxNotebooksCount.unwrap(value): Integer)
      )(_.maxResults)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNotebookMetadataRequest.ReadOnly =
    zio.aws.athena.model.ListNotebookMetadataRequest.wrap(buildAwsValue())
}
object ListNotebookMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNotebookMetadataRequest =
      zio.aws.athena.model.ListNotebookMetadataRequest(
        filters.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        workGroup
      )
    def filters: Optional[zio.aws.athena.model.FilterDefinition.ReadOnly]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxNotebooksCount]
    def workGroup: WorkGroupName
    def getFilters
        : ZIO[Any, AwsError, zio.aws.athena.model.FilterDefinition.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxNotebooksCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest
  ) extends zio.aws.athena.model.ListNotebookMetadataRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.athena.model.FilterDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.athena.model.FilterDefinition.wrap(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxNotebooksCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxNotebooksCount(value))
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest
  ): zio.aws.athena.model.ListNotebookMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
