package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionManagerToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCalculationExecutionsResponse(
    nextToken: Optional[SessionManagerToken] = Optional.Absent,
    calculations: Optional[Iterable[zio.aws.athena.model.CalculationSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse = {
    import ListCalculationExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          SessionManagerToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        calculations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.calculations)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly =
    zio.aws.athena.model.ListCalculationExecutionsResponse.wrap(buildAwsValue())
}
object ListCalculationExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListCalculationExecutionsResponse =
      zio.aws.athena.model.ListCalculationExecutionsResponse(
        nextToken.map(value => value),
        calculations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[SessionManagerToken]
    def calculations
        : Optional[List[zio.aws.athena.model.CalculationSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, SessionManagerToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCalculations: ZIO[Any, AwsError, List[
      zio.aws.athena.model.CalculationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("calculations", calculations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse
  ) extends zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly {
    override val nextToken: Optional[SessionManagerToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.athena.model.primitives.SessionManagerToken(value)
        )
    override val calculations
        : Optional[List[zio.aws.athena.model.CalculationSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.CalculationSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse
  ): zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
