package zio.aws.athena.model
import zio.aws.athena.model.primitives.QueryExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetQueryRuntimeStatisticsRequest(
    queryExecutionId: QueryExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest = {
    import GetQueryRuntimeStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest
      .builder()
      .queryExecutionId(
        QueryExecutionId.unwrap(queryExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetQueryRuntimeStatisticsRequest.ReadOnly =
    zio.aws.athena.model.GetQueryRuntimeStatisticsRequest.wrap(buildAwsValue())
}
object GetQueryRuntimeStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryRuntimeStatisticsRequest =
      zio.aws.athena.model.GetQueryRuntimeStatisticsRequest(queryExecutionId)
    def queryExecutionId: QueryExecutionId
    def getQueryExecutionId: ZIO[Any, Nothing, QueryExecutionId] =
      ZIO.succeed(queryExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest
  ) extends zio.aws.athena.model.GetQueryRuntimeStatisticsRequest.ReadOnly {
    override val queryExecutionId: QueryExecutionId =
      zio.aws.athena.model.primitives.QueryExecutionId(impl.queryExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest
  ): zio.aws.athena.model.GetQueryRuntimeStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
