package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutorType {
  def unwrap: software.amazon.awssdk.services.athena.model.ExecutorType
}
object ExecutorType {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.ExecutorType
  ): zio.aws.athena.model.ExecutorType = value match {
    case software.amazon.awssdk.services.athena.model.ExecutorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.ExecutorType.COORDINATOR =>
      val r = COORDINATOR
      r
    case software.amazon.awssdk.services.athena.model.ExecutorType.GATEWAY =>
      val r = GATEWAY
      r
    case software.amazon.awssdk.services.athena.model.ExecutorType.WORKER =>
      val r = WORKER
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorType =
      software.amazon.awssdk.services.athena.model.ExecutorType.UNKNOWN_TO_SDK_VERSION
  }
  case object COORDINATOR extends zio.aws.athena.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorType =
      software.amazon.awssdk.services.athena.model.ExecutorType.COORDINATOR
  }
  case object GATEWAY extends zio.aws.athena.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorType =
      software.amazon.awssdk.services.athena.model.ExecutorType.GATEWAY
  }
  case object WORKER extends zio.aws.athena.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ExecutorType =
      software.amazon.awssdk.services.athena.model.ExecutorType.WORKER
  }
}
