package zio.aws.athena.model
import zio.aws.athena.model.primitives.WorkGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CapacityAssignment(
    workGroupNames: Optional[Iterable[WorkGroupName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CapacityAssignment = {
    import CapacityAssignment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CapacityAssignment
      .builder()
      .optionallyWith(
        workGroupNames.map(value =>
          value.map { item =>
            WorkGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workGroupNames)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CapacityAssignment.ReadOnly =
    zio.aws.athena.model.CapacityAssignment.wrap(buildAwsValue())
}
object CapacityAssignment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CapacityAssignment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CapacityAssignment =
      zio.aws.athena.model
        .CapacityAssignment(workGroupNames.map(value => value))
    def workGroupNames: Optional[List[WorkGroupName]]
    def getWorkGroupNames: ZIO[Any, AwsError, List[WorkGroupName]] =
      AwsError.unwrapOptionField("workGroupNames", workGroupNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CapacityAssignment
  ) extends zio.aws.athena.model.CapacityAssignment.ReadOnly {
    override val workGroupNames: Optional[List[WorkGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workGroupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.primitives.WorkGroupName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CapacityAssignment
  ): zio.aws.athena.model.CapacityAssignment.ReadOnly = new Wrapper(impl)
}
