package zio.aws.athena.model
import zio.aws.athena.model.primitives.CalculationExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartCalculationExecutionResponse(
    calculationExecutionId: Optional[CalculationExecutionId] = Optional.Absent,
    state: Optional[zio.aws.athena.model.CalculationExecutionState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse = {
    import StartCalculationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse
      .builder()
      .optionallyWith(
        calculationExecutionId.map(value =>
          CalculationExecutionId.unwrap(value): java.lang.String
        )
      )(_.calculationExecutionId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly =
    zio.aws.athena.model.StartCalculationExecutionResponse.wrap(buildAwsValue())
}
object StartCalculationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartCalculationExecutionResponse =
      zio.aws.athena.model.StartCalculationExecutionResponse(
        calculationExecutionId.map(value => value),
        state.map(value => value)
      )
    def calculationExecutionId: Optional[CalculationExecutionId]
    def state: Optional[zio.aws.athena.model.CalculationExecutionState]
    def getCalculationExecutionId: ZIO[Any, AwsError, CalculationExecutionId] =
      AwsError.unwrapOptionField(
        "calculationExecutionId",
        calculationExecutionId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationExecutionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse
  ) extends zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly {
    override val calculationExecutionId: Optional[CalculationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculationExecutionId())
        .map(value =>
          zio.aws.athena.model.primitives.CalculationExecutionId(value)
        )
    override val state
        : Optional[zio.aws.athena.model.CalculationExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.athena.model.CalculationExecutionState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse
  ): zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
