package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryRuntimeStatistics(
    timeline: Optional[zio.aws.athena.model.QueryRuntimeStatisticsTimeline] =
      Optional.Absent,
    rows: Optional[zio.aws.athena.model.QueryRuntimeStatisticsRows] =
      Optional.Absent,
    outputStage: Optional[zio.aws.athena.model.QueryStage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryRuntimeStatistics = {
    import QueryRuntimeStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatistics
      .builder()
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .optionallyWith(rows.map(value => value.buildAwsValue()))(_.rows)
      .optionallyWith(outputStage.map(value => value.buildAwsValue()))(
        _.outputStage
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly =
    zio.aws.athena.model.QueryRuntimeStatistics.wrap(buildAwsValue())
}
object QueryRuntimeStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryRuntimeStatistics =
      zio.aws.athena.model.QueryRuntimeStatistics(
        timeline.map(value => value.asEditable),
        rows.map(value => value.asEditable),
        outputStage.map(value => value.asEditable)
      )
    def timeline
        : Optional[zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly]
    def rows: Optional[zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly]
    def outputStage: Optional[zio.aws.athena.model.QueryStage.ReadOnly]
    def getTimeline: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly
    ] = AwsError.unwrapOptionField("timeline", timeline)
    def getRows: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly
    ] = AwsError.unwrapOptionField("rows", rows)
    def getOutputStage
        : ZIO[Any, AwsError, zio.aws.athena.model.QueryStage.ReadOnly] =
      AwsError.unwrapOptionField("outputStage", outputStage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatistics
  ) extends zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly {
    override val timeline: Optional[
      zio.aws.athena.model.QueryRuntimeStatisticsTimeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeline())
      .map(value =>
        zio.aws.athena.model.QueryRuntimeStatisticsTimeline.wrap(value)
      )
    override val rows
        : Optional[zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rows())
        .map(value =>
          zio.aws.athena.model.QueryRuntimeStatisticsRows.wrap(value)
        )
    override val outputStage
        : Optional[zio.aws.athena.model.QueryStage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputStage())
        .map(value => zio.aws.athena.model.QueryStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatistics
  ): zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly = new Wrapper(impl)
}
