package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportNotebookResponse(
    notebookId: Optional[NotebookId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ImportNotebookResponse = {
    import ImportNotebookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ImportNotebookResponse
      .builder()
      .optionallyWith(
        notebookId.map(value => NotebookId.unwrap(value): java.lang.String)
      )(_.notebookId)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ImportNotebookResponse.ReadOnly =
    zio.aws.athena.model.ImportNotebookResponse.wrap(buildAwsValue())
}
object ImportNotebookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ImportNotebookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ImportNotebookResponse =
      zio.aws.athena.model
        .ImportNotebookResponse(notebookId.map(value => value))
    def notebookId: Optional[NotebookId]
    def getNotebookId: ZIO[Any, AwsError, NotebookId] =
      AwsError.unwrapOptionField("notebookId", notebookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ImportNotebookResponse
  ) extends zio.aws.athena.model.ImportNotebookResponse.ReadOnly {
    override val notebookId: Optional[NotebookId] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookId())
      .map(value => zio.aws.athena.model.primitives.NotebookId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ImportNotebookResponse
  ): zio.aws.athena.model.ImportNotebookResponse.ReadOnly = new Wrapper(impl)
}
