package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionStatusResponse(
    status: Optional[zio.aws.athena.model.CalculationStatus] = Optional.Absent,
    statistics: Optional[zio.aws.athena.model.CalculationStatistics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse = {
    import GetCalculationExecutionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionStatusResponse
      .wrap(buildAwsValue())
}
object GetCalculationExecutionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionStatusResponse =
      zio.aws.athena.model.GetCalculationExecutionStatusResponse(
        status.map(value => value.asEditable),
        statistics.map(value => value.asEditable)
      )
    def status: Optional[zio.aws.athena.model.CalculationStatus.ReadOnly]
    def statistics
        : Optional[zio.aws.athena.model.CalculationStatistics.ReadOnly]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.CalculationStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse
  ) extends zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly {
    override val status
        : Optional[zio.aws.athena.model.CalculationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.CalculationStatus.wrap(value))
    override val statistics
        : Optional[zio.aws.athena.model.CalculationStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.athena.model.CalculationStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse
  ): zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
