package zio.aws.athena.model
import zio.aws.athena.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EngineVersion(
    selectedEngineVersion: Optional[NameString] = Optional.Absent,
    effectiveEngineVersion: Optional[NameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.EngineVersion = {
    import EngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.EngineVersion
      .builder()
      .optionallyWith(
        selectedEngineVersion.map(value =>
          NameString.unwrap(value): java.lang.String
        )
      )(_.selectedEngineVersion)
      .optionallyWith(
        effectiveEngineVersion.map(value =>
          NameString.unwrap(value): java.lang.String
        )
      )(_.effectiveEngineVersion)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.EngineVersion.ReadOnly =
    zio.aws.athena.model.EngineVersion.wrap(buildAwsValue())
}
object EngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.EngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.EngineVersion =
      zio.aws.athena.model.EngineVersion(
        selectedEngineVersion.map(value => value),
        effectiveEngineVersion.map(value => value)
      )
    def selectedEngineVersion: Optional[NameString]
    def effectiveEngineVersion: Optional[NameString]
    def getSelectedEngineVersion: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("selectedEngineVersion", selectedEngineVersion)
    def getEffectiveEngineVersion: ZIO[Any, AwsError, NameString] = AwsError
      .unwrapOptionField("effectiveEngineVersion", effectiveEngineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.EngineVersion
  ) extends zio.aws.athena.model.EngineVersion.ReadOnly {
    override val selectedEngineVersion: Optional[NameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectedEngineVersion())
        .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val effectiveEngineVersion: Optional[NameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.effectiveEngineVersion())
        .map(value => zio.aws.athena.model.primitives.NameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.EngineVersion
  ): zio.aws.athena.model.EngineVersion.ReadOnly = new Wrapper(impl)
}
