package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNotebookRequest(notebookId: NotebookId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeleteNotebookRequest = {
    import DeleteNotebookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeleteNotebookRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DeleteNotebookRequest.ReadOnly =
    zio.aws.athena.model.DeleteNotebookRequest.wrap(buildAwsValue())
}
object DeleteNotebookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeleteNotebookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeleteNotebookRequest =
      zio.aws.athena.model.DeleteNotebookRequest(notebookId)
    def notebookId: NotebookId
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeleteNotebookRequest
  ) extends zio.aws.athena.model.DeleteNotebookRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeleteNotebookRequest
  ): zio.aws.athena.model.DeleteNotebookRequest.ReadOnly = new Wrapper(impl)
}
