package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCapacityReservationRequest(
    name: CapacityReservationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest = {
    import DeleteCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest
      .builder()
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.DeleteCapacityReservationRequest.ReadOnly =
    zio.aws.athena.model.DeleteCapacityReservationRequest.wrap(buildAwsValue())
}
object DeleteCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeleteCapacityReservationRequest =
      zio.aws.athena.model.DeleteCapacityReservationRequest(name)
    def name: CapacityReservationName
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest
  ) extends zio.aws.athena.model.DeleteCapacityReservationRequest.ReadOnly {
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest
  ): zio.aws.athena.model.DeleteCapacityReservationRequest.ReadOnly =
    new Wrapper(impl)
}
