package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  CapacityReservationName,
  TargetDpusInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateCapacityReservationRequest(
    targetDpus: TargetDpusInteger,
    name: CapacityReservationName,
    tags: Optional[Iterable[zio.aws.athena.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest = {
    import CreateCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest
      .builder()
      .targetDpus(TargetDpusInteger.unwrap(targetDpus): Integer)
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CreateCapacityReservationRequest.ReadOnly =
    zio.aws.athena.model.CreateCapacityReservationRequest.wrap(buildAwsValue())
}
object CreateCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateCapacityReservationRequest =
      zio.aws.athena.model.CreateCapacityReservationRequest(
        targetDpus,
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def targetDpus: TargetDpusInteger
    def name: CapacityReservationName
    def tags: Optional[List[zio.aws.athena.model.Tag.ReadOnly]]
    def getTargetDpus: ZIO[Any, Nothing, TargetDpusInteger] =
      ZIO.succeed(targetDpus)
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.athena.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest
  ) extends zio.aws.athena.model.CreateCapacityReservationRequest.ReadOnly {
    override val targetDpus: TargetDpusInteger =
      zio.aws.athena.model.primitives.TargetDpusInteger(impl.targetDpus())
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
    override val tags: Optional[List[zio.aws.athena.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest
  ): zio.aws.athena.model.CreateCapacityReservationRequest.ReadOnly =
    new Wrapper(impl)
}
