package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait CapacityReservationStatus {
  def unwrap
      : software.amazon.awssdk.services.athena.model.CapacityReservationStatus
}
object CapacityReservationStatus {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.CapacityReservationStatus
  ): zio.aws.athena.model.CapacityReservationStatus = value match {
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.athena.model.CapacityReservationStatus.UPDATE_PENDING =>
      val r = UPDATE_PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.PENDING
  }
  case object ACTIVE extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.ACTIVE
  }
  case object CANCELLING
      extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.CANCELLED
  }
  case object FAILED extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.FAILED
  }
  case object UPDATE_PENDING
      extends zio.aws.athena.model.CapacityReservationStatus {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.CapacityReservationStatus =
      software.amazon.awssdk.services.athena.model.CapacityReservationStatus.UPDATE_PENDING
  }
}
