package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{DescriptionString, Date}
import scala.jdk.CollectionConverters.*
final case class CalculationStatus(
    submissionDateTime: Optional[Date] = Optional.Absent,
    completionDateTime: Optional[Date] = Optional.Absent,
    state: Optional[zio.aws.athena.model.CalculationExecutionState] =
      Optional.Absent,
    stateChangeReason: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CalculationStatus = {
    import CalculationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CalculationStatus
      .builder()
      .optionallyWith(
        submissionDateTime.map(value => Date.unwrap(value): Instant)
      )(_.submissionDateTime)
      .optionallyWith(
        completionDateTime.map(value => Date.unwrap(value): Instant)
      )(_.completionDateTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateChangeReason.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.stateChangeReason)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CalculationStatus.ReadOnly =
    zio.aws.athena.model.CalculationStatus.wrap(buildAwsValue())
}
object CalculationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CalculationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CalculationStatus =
      zio.aws.athena.model.CalculationStatus(
        submissionDateTime.map(value => value),
        completionDateTime.map(value => value),
        state.map(value => value),
        stateChangeReason.map(value => value)
      )
    def submissionDateTime: Optional[Date]
    def completionDateTime: Optional[Date]
    def state: Optional[zio.aws.athena.model.CalculationExecutionState]
    def stateChangeReason: Optional[DescriptionString]
    def getSubmissionDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("submissionDateTime", submissionDateTime)
    def getCompletionDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("completionDateTime", completionDateTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationExecutionState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CalculationStatus
  ) extends zio.aws.athena.model.CalculationStatus.ReadOnly {
    override val submissionDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.submissionDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val completionDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val state
        : Optional[zio.aws.athena.model.CalculationExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.athena.model.CalculationExecutionState.wrap(value)
        )
    override val stateChangeReason: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeReason())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CalculationStatus
  ): zio.aws.athena.model.CalculationStatus.ReadOnly = new Wrapper(impl)
}
