package zio.aws.athena.model
import zio.aws.athena.model.primitives.DescriptionString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CalculationStatistics(
    dpuExecutionInMillis: Optional[Long] = Optional.Absent,
    progress: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CalculationStatistics = {
    import CalculationStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CalculationStatistics
      .builder()
      .optionallyWith(dpuExecutionInMillis.map(value => value: java.lang.Long))(
        _.dpuExecutionInMillis
      )
      .optionallyWith(
        progress.map(value => DescriptionString.unwrap(value): java.lang.String)
      )(_.progress)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CalculationStatistics.ReadOnly =
    zio.aws.athena.model.CalculationStatistics.wrap(buildAwsValue())
}
object CalculationStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CalculationStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CalculationStatistics =
      zio.aws.athena.model.CalculationStatistics(
        dpuExecutionInMillis.map(value => value),
        progress.map(value => value)
      )
    def dpuExecutionInMillis: Optional[Long]
    def progress: Optional[DescriptionString]
    def getDpuExecutionInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dpuExecutionInMillis", dpuExecutionInMillis)
    def getProgress: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("progress", progress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CalculationStatistics
  ) extends zio.aws.athena.model.CalculationStatistics.ReadOnly {
    override val dpuExecutionInMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dpuExecutionInMillis())
      .map(value => value: Long)
    override val progress: Optional[DescriptionString] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CalculationStatistics
  ): zio.aws.athena.model.CalculationStatistics.ReadOnly = new Wrapper(impl)
}
