package zio.aws.athena
import zio.aws.athena.model.ListCapacityReservationsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.athena.model.{
  CreateWorkGroupRequest,
  ListCalculationExecutionsRequest,
  UpdateNotebookMetadataRequest,
  ExportNotebookRequest,
  DeleteCapacityReservationRequest,
  ListNotebookMetadataRequest,
  GetDataCatalogRequest,
  GetWorkGroupRequest,
  ListWorkGroupsRequest,
  GetCalculationExecutionCodeRequest,
  GetCapacityReservationRequest,
  UpdateCapacityReservationRequest,
  GetNamedQueryRequest,
  CancelCapacityReservationRequest,
  DeleteDataCatalogRequest,
  ListTagsForResourceRequest,
  DeleteNotebookRequest,
  GetDatabaseRequest,
  BatchGetPreparedStatementRequest,
  CreatePreparedStatementRequest,
  DeleteWorkGroupRequest,
  DeletePreparedStatementRequest,
  ListDatabasesRequest,
  ListDataCatalogsRequest,
  GetPreparedStatementRequest,
  ListNotebookSessionsRequest,
  TerminateSessionRequest,
  ListQueryExecutionsRequest,
  ListPreparedStatementsRequest,
  GetQueryRuntimeStatisticsRequest,
  UpdateWorkGroupRequest,
  BatchGetQueryExecutionRequest,
  StartSessionRequest,
  GetCalculationExecutionStatusRequest,
  ListSessionsRequest,
  StartQueryExecutionRequest,
  ListCapacityReservationsRequest,
  CreatePresignedNotebookUrlRequest,
  ListTableMetadataRequest,
  StopCalculationExecutionRequest,
  CreateNamedQueryRequest,
  GetSessionRequest,
  ListEngineVersionsRequest,
  CreateDataCatalogRequest,
  UntagResourceRequest,
  GetSessionStatusRequest,
  GetQueryResultsRequest,
  GetTableMetadataRequest,
  ListExecutorsRequest,
  UpdateDataCatalogRequest,
  DeleteNamedQueryRequest,
  CreateCapacityReservationRequest,
  ImportNotebookRequest,
  UpdateNamedQueryRequest,
  UpdatePreparedStatementRequest,
  UpdateNotebookRequest,
  ListNamedQueriesRequest,
  GetCalculationExecutionRequest,
  ListApplicationDpuSizesRequest,
  GetQueryExecutionRequest,
  StopQueryExecutionRequest,
  PutCapacityAssignmentConfigurationRequest,
  GetCapacityAssignmentConfigurationRequest,
  StartCalculationExecutionRequest,
  BatchGetNamedQueryRequest,
  CreateNotebookRequest,
  TagResourceRequest,
  GetNotebookMetadataRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.athena.{
  AthenaAsyncClientBuilder,
  AthenaAsyncClient
}
import zio.aws.athena.model.primitives.{NamedQueryId, QueryExecutionId}
import zio.stream.ZStream
import software.amazon.awssdk.services.athena.model.{
  ListNotebookMetadataResponse,
  ListQueryExecutionsResponse,
  StartSessionResponse,
  UpdateNotebookResponse,
  ListApplicationDpuSizesResponse,
  UpdateNamedQueryResponse,
  GetWorkGroupResponse,
  CreatePresignedNotebookUrlResponse,
  GetCalculationExecutionStatusResponse,
  CreateWorkGroupResponse,
  GetCalculationExecutionResponse,
  UpdateWorkGroupResponse,
  GetCapacityReservationResponse,
  WorkGroupSummary,
  SessionSummary,
  CreateNamedQueryResponse,
  TerminateSessionResponse,
  StartCalculationExecutionResponse,
  GetTableMetadataResponse,
  ListSessionsResponse,
  ApplicationDPUSizes,
  NotebookMetadata,
  StopCalculationExecutionResponse,
  CreateDataCatalogResponse,
  ExecutorsSummary,
  DeleteCapacityReservationResponse,
  PreparedStatementSummary,
  GetDatabaseResponse,
  ListCalculationExecutionsResponse,
  BatchGetPreparedStatementResponse,
  ListDatabasesResponse,
  GetPreparedStatementResponse,
  Tag,
  CancelCapacityReservationResponse,
  TableMetadata,
  ListPreparedStatementsResponse,
  UpdateNotebookMetadataResponse,
  CreatePreparedStatementResponse,
  EngineVersion,
  GetQueryResultsResponse,
  ListTagsForResourceResponse,
  UpdateDataCatalogResponse,
  UntagResourceResponse,
  DeletePreparedStatementResponse,
  DeleteNamedQueryResponse,
  StopQueryExecutionResponse,
  BatchGetQueryExecutionResponse,
  UpdatePreparedStatementResponse,
  ListNotebookSessionsResponse,
  DataCatalogSummary,
  NotebookSessionSummary,
  GetNamedQueryResponse,
  GetDataCatalogResponse,
  GetQueryRuntimeStatisticsResponse,
  ListWorkGroupsResponse,
  CapacityReservation,
  Database,
  GetCalculationExecutionCodeResponse,
  ListNamedQueriesResponse,
  ListTableMetadataResponse,
  DeleteNotebookResponse,
  ImportNotebookResponse,
  CalculationSummary,
  CreateCapacityReservationResponse,
  DeleteWorkGroupResponse,
  ListCapacityReservationsResponse,
  UpdateCapacityReservationResponse,
  ListEngineVersionsResponse,
  GetSessionResponse,
  GetQueryExecutionResponse,
  GetSessionStatusResponse,
  GetNotebookMetadataResponse,
  PutCapacityAssignmentConfigurationResponse,
  BatchGetNamedQueryResponse,
  DeleteDataCatalogResponse,
  TagResourceResponse,
  ExportNotebookResponse,
  ListDataCatalogsResponse,
  StartQueryExecutionResponse,
  ListExecutorsResponse,
  Row,
  CreateNotebookResponse,
  GetCapacityAssignmentConfigurationResponse
}
import scala.jdk.CollectionConverters.*
trait Athena extends AspectSupport[Athena] {
  val api: AthenaAsyncClient
  def listDatabases(
      request: ListDatabasesRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly]
  def listDatabasesPaginated(
      request: ListDatabasesRequest
  ): IO[AwsError, zio.aws.athena.model.ListDatabasesResponse.ReadOnly]
  def updateDataCatalog(
      request: UpdateDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly]
  def listNotebookSessions(request: ListNotebookSessionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.athena.model.NotebookSessionSummary.ReadOnly
  ]
  def listNotebookSessionsPaginated(
      request: ListNotebookSessionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly]
  def updateWorkGroup(
      request: UpdateWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly]
  def stopCalculationExecution(request: StopCalculationExecutionRequest): IO[
    AwsError,
    zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly
  ]
  def deleteCapacityReservation(request: DeleteCapacityReservationRequest): IO[
    AwsError,
    zio.aws.athena.model.DeleteCapacityReservationResponse.ReadOnly
  ]
  def getPreparedStatement(
      request: GetPreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly]
  def listQueryExecutions(
      request: ListQueryExecutionsRequest
  ): ZStream[Any, AwsError, QueryExecutionId]
  def listQueryExecutionsPaginated(
      request: ListQueryExecutionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly]
  def listDataCatalogs(
      request: ListDataCatalogsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.DataCatalogSummary.ReadOnly]
  def listDataCatalogsPaginated(
      request: ListDataCatalogsRequest
  ): IO[AwsError, zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly]
  def getNamedQuery(
      request: GetNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.GetNamedQueryResponse.ReadOnly]
  def getNotebookMetadata(
      request: GetNotebookMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly]
  def updateNamedQuery(
      request: UpdateNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly]
  def listExecutors(
      request: ListExecutorsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ListExecutorsResponse.ReadOnly,
    zio.aws.athena.model.ExecutorsSummary.ReadOnly
  ]]
  def listExecutorsPaginated(
      request: ListExecutorsRequest
  ): IO[AwsError, zio.aws.athena.model.ListExecutorsResponse.ReadOnly]
  def deletePreparedStatement(
      request: DeletePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly]
  def listEngineVersions(
      request: ListEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly]
  def listEngineVersionsPaginated(
      request: ListEngineVersionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly]
  def getQueryRuntimeStatistics(request: GetQueryRuntimeStatisticsRequest): IO[
    AwsError,
    zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly
  ]
  def deleteNamedQuery(
      request: DeleteNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly]
  def updateNotebookMetadata(
      request: UpdateNotebookMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateNotebookMetadataResponse.ReadOnly]
  def getTableMetadata(
      request: GetTableMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.GetTableMetadataResponse.ReadOnly]
  def batchGetNamedQuery(
      request: BatchGetNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly]
  def listApplicationDPUSizes(
      request: ListApplicationDpuSizesRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.ApplicationDPUSizes.ReadOnly]
  def listApplicationDPUSizesPaginated(
      request: ListApplicationDpuSizesRequest
  ): IO[AwsError, zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly]
  def createNamedQuery(
      request: CreateNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly]
  def terminateSession(
      request: TerminateSessionRequest
  ): IO[AwsError, zio.aws.athena.model.TerminateSessionResponse.ReadOnly]
  def getDataCatalog(
      request: GetDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.GetDataCatalogResponse.ReadOnly]
  def deleteNotebook(
      request: DeleteNotebookRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteNotebookResponse.ReadOnly]
  def createNotebook(
      request: CreateNotebookRequest
  ): IO[AwsError, zio.aws.athena.model.CreateNotebookResponse.ReadOnly]
  def listCalculationExecutions(
      request: ListCalculationExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.CalculationSummary.ReadOnly]
  def listCalculationExecutionsPaginated(
      request: ListCalculationExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly
  ]
  def getCapacityReservation(
      request: GetCapacityReservationRequest
  ): IO[AwsError, zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly]
  def createCapacityReservation(request: CreateCapacityReservationRequest): IO[
    AwsError,
    zio.aws.athena.model.CreateCapacityReservationResponse.ReadOnly
  ]
  def listWorkGroups(
      request: ListWorkGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.WorkGroupSummary.ReadOnly]
  def listWorkGroupsPaginated(
      request: ListWorkGroupsRequest
  ): IO[AwsError, zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly]
  def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.athena.model.PreparedStatementSummary.ReadOnly
  ]
  def listPreparedStatementsPaginated(
      request: ListPreparedStatementsRequest
  ): IO[AwsError, zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly]
  def createPreparedStatement(
      request: CreatePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly]
  def deleteDataCatalog(
      request: DeleteDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly]
  def updateNotebook(
      request: UpdateNotebookRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateNotebookResponse.ReadOnly]
  def listCapacityReservations(
      request: ListCapacityReservationsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.CapacityReservation.ReadOnly]
  def listCapacityReservationsPaginated(
      request: ListCapacityReservationsRequest
  ): IO[AwsError, ReadOnly]
  def listNotebookMetadata(
      request: ListNotebookMetadataRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.NotebookMetadata.ReadOnly]
  def listNotebookMetadataPaginated(
      request: ListNotebookMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly]
  def createPresignedNotebookUrl(
      request: CreatePresignedNotebookUrlRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly
  ]
  def getQueryExecution(
      request: GetQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly]
  def updatePreparedStatement(
      request: UpdatePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly]
  def createDataCatalog(
      request: CreateDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.athena.model.UntagResourceResponse.ReadOnly]
  def exportNotebook(
      request: ExportNotebookRequest
  ): IO[AwsError, zio.aws.athena.model.ExportNotebookResponse.ReadOnly]
  def getSessionStatus(
      request: GetSessionStatusRequest
  ): IO[AwsError, zio.aws.athena.model.GetSessionStatusResponse.ReadOnly]
  def listTableMetadata(
      request: ListTableMetadataRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.TableMetadata.ReadOnly]
  def listTableMetadataPaginated(
      request: ListTableMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.ListTableMetadataResponse.ReadOnly]
  def cancelCapacityReservation(request: CancelCapacityReservationRequest): IO[
    AwsError,
    zio.aws.athena.model.CancelCapacityReservationResponse.ReadOnly
  ]
  def startCalculationExecution(request: StartCalculationExecutionRequest): IO[
    AwsError,
    zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly
  ]
  def updateCapacityReservation(request: UpdateCapacityReservationRequest): IO[
    AwsError,
    zio.aws.athena.model.UpdateCapacityReservationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly]
  def getCapacityAssignmentConfiguration(
      request: GetCapacityAssignmentConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.GetCapacityAssignmentConfigurationResponse.ReadOnly
  ]
  def startSession(
      request: StartSessionRequest
  ): IO[AwsError, zio.aws.athena.model.StartSessionResponse.ReadOnly]
  def listSessions(
      request: ListSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.SessionSummary.ReadOnly]
  def listSessionsPaginated(
      request: ListSessionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListSessionsResponse.ReadOnly]
  def getCalculationExecutionCode(
      request: GetCalculationExecutionCodeRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly
  ]
  def listNamedQueries(
      request: ListNamedQueriesRequest
  ): ZStream[Any, AwsError, NamedQueryId]
  def listNamedQueriesPaginated(
      request: ListNamedQueriesRequest
  ): IO[AwsError, zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly]
  def putCapacityAssignmentConfiguration(
      request: PutCapacityAssignmentConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.PutCapacityAssignmentConfigurationResponse.ReadOnly
  ]
  def deleteWorkGroup(
      request: DeleteWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly]
  def getSession(
      request: GetSessionRequest
  ): IO[AwsError, zio.aws.athena.model.GetSessionResponse.ReadOnly]
  def importNotebook(
      request: ImportNotebookRequest
  ): IO[AwsError, zio.aws.athena.model.ImportNotebookResponse.ReadOnly]
  def getDatabase(
      request: GetDatabaseRequest
  ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly]
  def getCalculationExecutionStatus(
      request: GetCalculationExecutionStatusRequest
  ): IO[
    AwsError,
    zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly
  ]
  def batchGetPreparedStatement(request: BatchGetPreparedStatementRequest): IO[
    AwsError,
    zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly
  ]
  def createWorkGroup(
      request: CreateWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly]
  def getWorkGroup(
      request: GetWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.GetWorkGroupResponse.ReadOnly]
  def batchGetQueryExecution(
      request: BatchGetQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly]
  def getCalculationExecution(
      request: GetCalculationExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly]
  def startQueryExecution(
      request: StartQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly]
  def getQueryResults(
      request: GetQueryResultsRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ResultSetMetadata.ReadOnly,
    zio.aws.athena.model.Row.ReadOnly
  ]]
  def getQueryResultsPaginated(
      request: GetQueryResultsRequest
  ): IO[AwsError, zio.aws.athena.model.GetQueryResultsResponse.ReadOnly]
  def stopQueryExecution(
      request: StopQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly]
}
object Athena {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Athena] = customized(
    identity
  )
  def customized(
      customization: AthenaAsyncClientBuilder => AthenaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Athena] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AthenaAsyncClientBuilder => AthenaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Athena] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AthenaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AthenaAsyncClient, AthenaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AthenaAsyncClient, AthenaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AthenaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AthenaImpl[R](
      override val api: AthenaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Athena
      with AwsServiceBase[R] {
    override val serviceName: String = "Athena"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AthenaImpl[R1] = new AthenaImpl(api, newAspect, r)
    def listDatabases(
        request: ListDatabasesRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListDatabasesRequest,
        ListDatabasesResponse,
        Database
      ](
        "listDatabases",
        api.listDatabases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.databaseList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.Database.wrap(item))
        .provideEnvironment(r)
    def listDatabasesPaginated(
        request: ListDatabasesRequest
    ): IO[AwsError, zio.aws.athena.model.ListDatabasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListDatabasesRequest,
        ListDatabasesResponse
      ]("listDatabases", api.listDatabases)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListDatabasesResponse.wrap)
        .provideEnvironment(r)
    def updateDataCatalog(
        request: UpdateDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest,
        UpdateDataCatalogResponse
      ]("updateDataCatalog", api.updateDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def listNotebookSessions(request: ListNotebookSessionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.NotebookSessionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest,
      ListNotebookSessionsResponse,
      NotebookSessionSummary
    ](
      "listNotebookSessions",
      api.listNotebookSessions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notebookSessionsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.NotebookSessionSummary.wrap(item))
      .provideEnvironment(r)
    def listNotebookSessionsPaginated(request: ListNotebookSessionsRequest): IO[
      AwsError,
      zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest,
      ListNotebookSessionsResponse
    ]("listNotebookSessions", api.listNotebookSessions)(request.buildAwsValue())
      .map(zio.aws.athena.model.ListNotebookSessionsResponse.wrap)
      .provideEnvironment(r)
    def updateWorkGroup(
        request: UpdateWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest,
        UpdateWorkGroupResponse
      ]("updateWorkGroup", api.updateWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def stopCalculationExecution(request: StopCalculationExecutionRequest): IO[
      AwsError,
      zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest,
      StopCalculationExecutionResponse
    ]("stopCalculationExecution", api.stopCalculationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.StopCalculationExecutionResponse.wrap)
      .provideEnvironment(r)
    def deleteCapacityReservation(
        request: DeleteCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.DeleteCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest,
      DeleteCapacityReservationResponse
    ]("deleteCapacityReservation", api.deleteCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.DeleteCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def getPreparedStatement(request: GetPreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest,
      GetPreparedStatementResponse
    ]("getPreparedStatement", api.getPreparedStatement)(request.buildAwsValue())
      .map(zio.aws.athena.model.GetPreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def listQueryExecutions(
        request: ListQueryExecutionsRequest
    ): ZStream[Any, AwsError, QueryExecutionId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest,
      ListQueryExecutionsResponse,
      java.lang.String
    ](
      "listQueryExecutions",
      api.listQueryExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queryExecutionIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.primitives.QueryExecutionId(item))
      .provideEnvironment(r)
    def listQueryExecutionsPaginated(
        request: ListQueryExecutionsRequest
    ): IO[AwsError, zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest,
        ListQueryExecutionsResponse
      ]("listQueryExecutions", api.listQueryExecutions)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListQueryExecutionsResponse.wrap)
        .provideEnvironment(r)
    def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.DataCatalogSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest,
      ListDataCatalogsResponse,
      DataCatalogSummary
    ](
      "listDataCatalogs",
      api.listDataCatalogs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataCatalogsSummary().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.DataCatalogSummary.wrap(item))
      .provideEnvironment(r)
    def listDataCatalogsPaginated(
        request: ListDataCatalogsRequest
    ): IO[AwsError, zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest,
        ListDataCatalogsResponse
      ]("listDataCatalogs", api.listDataCatalogs)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListDataCatalogsResponse.wrap)
        .provideEnvironment(r)
    def getNamedQuery(
        request: GetNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.GetNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetNamedQueryRequest,
        GetNamedQueryResponse
      ]("getNamedQuery", api.getNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def getNotebookMetadata(
        request: GetNotebookMetadataRequest
    ): IO[AwsError, zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest,
        GetNotebookMetadataResponse
      ]("getNotebookMetadata", api.getNotebookMetadata)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetNotebookMetadataResponse.wrap)
        .provideEnvironment(r)
    def updateNamedQuery(
        request: UpdateNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest,
        UpdateNamedQueryResponse
      ]("updateNamedQuery", api.updateNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def listExecutors(
        request: ListExecutorsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.athena.model.ListExecutorsResponse.ReadOnly,
      zio.aws.athena.model.ExecutorsSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListExecutorsRequest,
      ListExecutorsResponse,
      ExecutorsSummary
    ](
      "listExecutors",
      api.listExecutors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.executorsSummary().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.athena.model.ListExecutorsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.athena.model.ExecutorsSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listExecutorsPaginated(
        request: ListExecutorsRequest
    ): IO[AwsError, zio.aws.athena.model.ListExecutorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListExecutorsRequest,
        ListExecutorsResponse
      ]("listExecutors", api.listExecutors)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListExecutorsResponse.wrap)
        .provideEnvironment(r)
    def deletePreparedStatement(request: DeletePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest,
      DeletePreparedStatementResponse
    ]("deletePreparedStatement", api.deletePreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.DeletePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def listEngineVersions(
        request: ListEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest,
        ListEngineVersionsResponse,
        EngineVersion
      ](
        "listEngineVersions",
        api.listEngineVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.engineVersions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.EngineVersion.wrap(item))
        .provideEnvironment(r)
    def listEngineVersionsPaginated(
        request: ListEngineVersionsRequest
    ): IO[AwsError, zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest,
        ListEngineVersionsResponse
      ]("listEngineVersions", api.listEngineVersions)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListEngineVersionsResponse.wrap)
        .provideEnvironment(r)
    def getQueryRuntimeStatistics(
        request: GetQueryRuntimeStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest,
      GetQueryRuntimeStatisticsResponse
    ]("getQueryRuntimeStatistics", api.getQueryRuntimeStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.wrap)
      .provideEnvironment(r)
    def deleteNamedQuery(
        request: DeleteNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest,
        DeleteNamedQueryResponse
      ]("deleteNamedQuery", api.deleteNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def updateNotebookMetadata(request: UpdateNotebookMetadataRequest): IO[
      AwsError,
      zio.aws.athena.model.UpdateNotebookMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest,
      UpdateNotebookMetadataResponse
    ]("updateNotebookMetadata", api.updateNotebookMetadata)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.UpdateNotebookMetadataResponse.wrap)
      .provideEnvironment(r)
    def getTableMetadata(
        request: GetTableMetadataRequest
    ): IO[AwsError, zio.aws.athena.model.GetTableMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetTableMetadataRequest,
        GetTableMetadataResponse
      ]("getTableMetadata", api.getTableMetadata)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetTableMetadataResponse.wrap)
        .provideEnvironment(r)
    def batchGetNamedQuery(
        request: BatchGetNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest,
        BatchGetNamedQueryResponse
      ]("batchGetNamedQuery", api.batchGetNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.BatchGetNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def listApplicationDPUSizes(
        request: ListApplicationDpuSizesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.ApplicationDPUSizes.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest,
      ListApplicationDpuSizesResponse,
      ApplicationDPUSizes
    ](
      "listApplicationDPUSizes",
      api.listApplicationDPUSizes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationDPUSizes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.ApplicationDPUSizes.wrap(item))
      .provideEnvironment(r)
    def listApplicationDPUSizesPaginated(
        request: ListApplicationDpuSizesRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest,
      ListApplicationDpuSizesResponse
    ]("listApplicationDPUSizes", api.listApplicationDPUSizes)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.ListApplicationDpuSizesResponse.wrap)
      .provideEnvironment(r)
    def createNamedQuery(
        request: CreateNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest,
        CreateNamedQueryResponse
      ]("createNamedQuery", api.createNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def terminateSession(
        request: TerminateSessionRequest
    ): IO[AwsError, zio.aws.athena.model.TerminateSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.TerminateSessionRequest,
        TerminateSessionResponse
      ]("terminateSession", api.terminateSession)(request.buildAwsValue())
        .map(zio.aws.athena.model.TerminateSessionResponse.wrap)
        .provideEnvironment(r)
    def getDataCatalog(
        request: GetDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.GetDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetDataCatalogRequest,
        GetDataCatalogResponse
      ]("getDataCatalog", api.getDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def deleteNotebook(
        request: DeleteNotebookRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteNotebookResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteNotebookRequest,
        DeleteNotebookResponse
      ]("deleteNotebook", api.deleteNotebook)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteNotebookResponse.wrap)
        .provideEnvironment(r)
    def createNotebook(
        request: CreateNotebookRequest
    ): IO[AwsError, zio.aws.athena.model.CreateNotebookResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateNotebookRequest,
        CreateNotebookResponse
      ]("createNotebook", api.createNotebook)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateNotebookResponse.wrap)
        .provideEnvironment(r)
    def listCalculationExecutions(
        request: ListCalculationExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.CalculationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest,
      ListCalculationExecutionsResponse,
      CalculationSummary
    ](
      "listCalculationExecutions",
      api.listCalculationExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.calculations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.CalculationSummary.wrap(item))
      .provideEnvironment(r)
    def listCalculationExecutionsPaginated(
        request: ListCalculationExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest,
      ListCalculationExecutionsResponse
    ]("listCalculationExecutions", api.listCalculationExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.ListCalculationExecutionsResponse.wrap)
      .provideEnvironment(r)
    def getCapacityReservation(request: GetCapacityReservationRequest): IO[
      AwsError,
      zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest,
      GetCapacityReservationResponse
    ]("getCapacityReservation", api.getCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.GetCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def createCapacityReservation(
        request: CreateCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.CreateCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest,
      CreateCapacityReservationResponse
    ]("createCapacityReservation", api.createCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.CreateCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def listWorkGroups(
        request: ListWorkGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.WorkGroupSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest,
        ListWorkGroupsResponse,
        WorkGroupSummary
      ](
        "listWorkGroups",
        api.listWorkGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.WorkGroupSummary.wrap(item))
        .provideEnvironment(r)
    def listWorkGroupsPaginated(
        request: ListWorkGroupsRequest
    ): IO[AwsError, zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest,
        ListWorkGroupsResponse
      ]("listWorkGroups", api.listWorkGroups)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListWorkGroupsResponse.wrap)
        .provideEnvironment(r)
    def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.PreparedStatementSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest,
      ListPreparedStatementsResponse,
      PreparedStatementSummary
    ](
      "listPreparedStatements",
      api.listPreparedStatements,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.preparedStatements().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.PreparedStatementSummary.wrap(item))
      .provideEnvironment(r)
    def listPreparedStatementsPaginated(
        request: ListPreparedStatementsRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest,
      ListPreparedStatementsResponse
    ]("listPreparedStatements", api.listPreparedStatements)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.ListPreparedStatementsResponse.wrap)
      .provideEnvironment(r)
    def createPreparedStatement(request: CreatePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest,
      CreatePreparedStatementResponse
    ]("createPreparedStatement", api.createPreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.CreatePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def deleteDataCatalog(
        request: DeleteDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest,
        DeleteDataCatalogResponse
      ]("deleteDataCatalog", api.deleteDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def updateNotebook(
        request: UpdateNotebookRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateNotebookResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateNotebookRequest,
        UpdateNotebookResponse
      ]("updateNotebook", api.updateNotebook)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateNotebookResponse.wrap)
        .provideEnvironment(r)
    def listCapacityReservations(
        request: ListCapacityReservationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.CapacityReservation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest,
      ListCapacityReservationsResponse,
      CapacityReservation
    ](
      "listCapacityReservations",
      api.listCapacityReservations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.capacityReservations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.CapacityReservation.wrap(item))
      .provideEnvironment(r)
    def listCapacityReservationsPaginated(
        request: ListCapacityReservationsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest,
      ListCapacityReservationsResponse
    ]("listCapacityReservations", api.listCapacityReservations)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.ListCapacityReservationsResponse.wrap)
      .provideEnvironment(r)
    def listNotebookMetadata(request: ListNotebookMetadataRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.NotebookMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest,
      ListNotebookMetadataResponse,
      NotebookMetadata
    ](
      "listNotebookMetadata",
      api.listNotebookMetadata,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notebookMetadataList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.NotebookMetadata.wrap(item))
      .provideEnvironment(r)
    def listNotebookMetadataPaginated(request: ListNotebookMetadataRequest): IO[
      AwsError,
      zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest,
      ListNotebookMetadataResponse
    ]("listNotebookMetadata", api.listNotebookMetadata)(request.buildAwsValue())
      .map(zio.aws.athena.model.ListNotebookMetadataResponse.wrap)
      .provideEnvironment(r)
    def createPresignedNotebookUrl(
        request: CreatePresignedNotebookUrlRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest,
      CreatePresignedNotebookUrlResponse
    ]("createPresignedNotebookUrl", api.createPresignedNotebookUrl)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.CreatePresignedNotebookUrlResponse.wrap)
      .provideEnvironment(r)
    def getQueryExecution(
        request: GetQueryExecutionRequest
    ): IO[AwsError, zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest,
        GetQueryExecutionResponse
      ]("getQueryExecution", api.getQueryExecution)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetQueryExecutionResponse.wrap)
        .provideEnvironment(r)
    def updatePreparedStatement(request: UpdatePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest,
      UpdatePreparedStatementResponse
    ]("updatePreparedStatement", api.updatePreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.UpdatePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def createDataCatalog(
        request: CreateDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest,
        CreateDataCatalogResponse
      ]("createDataCatalog", api.createDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.athena.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def exportNotebook(
        request: ExportNotebookRequest
    ): IO[AwsError, zio.aws.athena.model.ExportNotebookResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ExportNotebookRequest,
        ExportNotebookResponse
      ]("exportNotebook", api.exportNotebook)(request.buildAwsValue())
        .map(zio.aws.athena.model.ExportNotebookResponse.wrap)
        .provideEnvironment(r)
    def getSessionStatus(
        request: GetSessionStatusRequest
    ): IO[AwsError, zio.aws.athena.model.GetSessionStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetSessionStatusRequest,
        GetSessionStatusResponse
      ]("getSessionStatus", api.getSessionStatus)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetSessionStatusResponse.wrap)
        .provideEnvironment(r)
    def listTableMetadata(
        request: ListTableMetadataRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.TableMetadata.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListTableMetadataRequest,
        ListTableMetadataResponse,
        TableMetadata
      ](
        "listTableMetadata",
        api.listTableMetadata,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tableMetadataList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.TableMetadata.wrap(item))
        .provideEnvironment(r)
    def listTableMetadataPaginated(
        request: ListTableMetadataRequest
    ): IO[AwsError, zio.aws.athena.model.ListTableMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListTableMetadataRequest,
        ListTableMetadataResponse
      ]("listTableMetadata", api.listTableMetadata)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListTableMetadataResponse.wrap)
        .provideEnvironment(r)
    def cancelCapacityReservation(
        request: CancelCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.CancelCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest,
      CancelCapacityReservationResponse
    ]("cancelCapacityReservation", api.cancelCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.CancelCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def startCalculationExecution(
        request: StartCalculationExecutionRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest,
      StartCalculationExecutionResponse
    ]("startCalculationExecution", api.startCalculationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.StartCalculationExecutionResponse.wrap)
      .provideEnvironment(r)
    def updateCapacityReservation(
        request: UpdateCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.UpdateCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest,
      UpdateCapacityReservationResponse
    ]("updateCapacityReservation", api.updateCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.UpdateCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getCapacityAssignmentConfiguration(
        request: GetCapacityAssignmentConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.GetCapacityAssignmentConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest,
      GetCapacityAssignmentConfigurationResponse
    ](
      "getCapacityAssignmentConfiguration",
      api.getCapacityAssignmentConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.athena.model.GetCapacityAssignmentConfigurationResponse.wrap)
      .provideEnvironment(r)
    def startSession(
        request: StartSessionRequest
    ): IO[AwsError, zio.aws.athena.model.StartSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.StartSessionRequest,
        StartSessionResponse
      ]("startSession", api.startSession)(request.buildAwsValue())
        .map(zio.aws.athena.model.StartSessionResponse.wrap)
        .provideEnvironment(r)
    def listSessions(
        request: ListSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.SessionSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListSessionsRequest,
        ListSessionsResponse,
        SessionSummary
      ](
        "listSessions",
        api.listSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.SessionSummary.wrap(item))
        .provideEnvironment(r)
    def listSessionsPaginated(
        request: ListSessionsRequest
    ): IO[AwsError, zio.aws.athena.model.ListSessionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListSessionsRequest,
        ListSessionsResponse
      ]("listSessions", api.listSessions)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListSessionsResponse.wrap)
        .provideEnvironment(r)
    def getCalculationExecutionCode(
        request: GetCalculationExecutionCodeRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest,
      GetCalculationExecutionCodeResponse
    ]("getCalculationExecutionCode", api.getCalculationExecutionCode)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.GetCalculationExecutionCodeResponse.wrap)
      .provideEnvironment(r)
    def listNamedQueries(
        request: ListNamedQueriesRequest
    ): ZStream[Any, AwsError, NamedQueryId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest,
      ListNamedQueriesResponse,
      java.lang.String
    ](
      "listNamedQueries",
      api.listNamedQueries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.namedQueryIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.primitives.NamedQueryId(item))
      .provideEnvironment(r)
    def listNamedQueriesPaginated(
        request: ListNamedQueriesRequest
    ): IO[AwsError, zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest,
        ListNamedQueriesResponse
      ]("listNamedQueries", api.listNamedQueries)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListNamedQueriesResponse.wrap)
        .provideEnvironment(r)
    def putCapacityAssignmentConfiguration(
        request: PutCapacityAssignmentConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.PutCapacityAssignmentConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest,
      PutCapacityAssignmentConfigurationResponse
    ](
      "putCapacityAssignmentConfiguration",
      api.putCapacityAssignmentConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.athena.model.PutCapacityAssignmentConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkGroup(
        request: DeleteWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest,
        DeleteWorkGroupResponse
      ]("deleteWorkGroup", api.deleteWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def getSession(
        request: GetSessionRequest
    ): IO[AwsError, zio.aws.athena.model.GetSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetSessionRequest,
        GetSessionResponse
      ]("getSession", api.getSession)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetSessionResponse.wrap)
        .provideEnvironment(r)
    def importNotebook(
        request: ImportNotebookRequest
    ): IO[AwsError, zio.aws.athena.model.ImportNotebookResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ImportNotebookRequest,
        ImportNotebookResponse
      ]("importNotebook", api.importNotebook)(request.buildAwsValue())
        .map(zio.aws.athena.model.ImportNotebookResponse.wrap)
        .provideEnvironment(r)
    def getDatabase(
        request: GetDatabaseRequest
    ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetDatabaseRequest,
        GetDatabaseResponse
      ]("getDatabase", api.getDatabase)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetDatabaseResponse.wrap)
        .provideEnvironment(r)
    def getCalculationExecutionStatus(
        request: GetCalculationExecutionStatusRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest,
      GetCalculationExecutionStatusResponse
    ]("getCalculationExecutionStatus", api.getCalculationExecutionStatus)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.GetCalculationExecutionStatusResponse.wrap)
      .provideEnvironment(r)
    def batchGetPreparedStatement(
        request: BatchGetPreparedStatementRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest,
      BatchGetPreparedStatementResponse
    ]("batchGetPreparedStatement", api.batchGetPreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.BatchGetPreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def createWorkGroup(
        request: CreateWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest,
        CreateWorkGroupResponse
      ]("createWorkGroup", api.createWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def getWorkGroup(
        request: GetWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.GetWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetWorkGroupRequest,
        GetWorkGroupResponse
      ]("getWorkGroup", api.getWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def batchGetQueryExecution(request: BatchGetQueryExecutionRequest): IO[
      AwsError,
      zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest,
      BatchGetQueryExecutionResponse
    ]("batchGetQueryExecution", api.batchGetQueryExecution)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.BatchGetQueryExecutionResponse.wrap)
      .provideEnvironment(r)
    def getCalculationExecution(request: GetCalculationExecutionRequest): IO[
      AwsError,
      zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest,
      GetCalculationExecutionResponse
    ]("getCalculationExecution", api.getCalculationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.GetCalculationExecutionResponse.wrap)
      .provideEnvironment(r)
    def startQueryExecution(
        request: StartQueryExecutionRequest
    ): IO[AwsError, zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest,
        StartQueryExecutionResponse
      ]("startQueryExecution", api.startQueryExecution)(request.buildAwsValue())
        .map(zio.aws.athena.model.StartQueryExecutionResponse.wrap)
        .provideEnvironment(r)
    def getQueryResults(
        request: GetQueryResultsRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.athena.model.ResultSetMetadata.ReadOnly,
      zio.aws.athena.model.Row.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.athena.model.GetQueryResultsRequest,
      GetQueryResultsResponse,
      Row
    ](
      "getQueryResults",
      api.getQueryResults,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resultSet().rows().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(r =>
            zio.aws.athena.model.ResultSetMetadata
              .wrap(r.resultSet().resultSetMetadata())
          )
          .mapOutput(_.map(item => zio.aws.athena.model.Row.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getQueryResultsPaginated(
        request: GetQueryResultsRequest
    ): IO[AwsError, zio.aws.athena.model.GetQueryResultsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetQueryResultsRequest,
        GetQueryResultsResponse
      ]("getQueryResults", api.getQueryResults)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetQueryResultsResponse.wrap)
        .provideEnvironment(r)
    def stopQueryExecution(
        request: StopQueryExecutionRequest
    ): IO[AwsError, zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest,
        StopQueryExecutionResponse
      ]("stopQueryExecution", api.stopQueryExecution)(request.buildAwsValue())
        .map(zio.aws.athena.model.StopQueryExecutionResponse.wrap)
        .provideEnvironment(r)
  }
  def listDatabases(request: ListDatabasesRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.Database.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatabases(request))
  def listDatabasesPaginated(request: ListDatabasesRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatabasesPaginated(request))
  def updateDataCatalog(request: UpdateDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataCatalog(request))
  def listNotebookSessions(request: ListNotebookSessionsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.NotebookSessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotebookSessions(request))
  def listNotebookSessionsPaginated(request: ListNotebookSessionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotebookSessionsPaginated(request))
  def updateWorkGroup(request: UpdateWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkGroup(request))
  def stopCalculationExecution(request: StopCalculationExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopCalculationExecution(request))
  def deleteCapacityReservation(request: DeleteCapacityReservationRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCapacityReservation(request))
  def getPreparedStatement(request: GetPreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPreparedStatement(request))
  def listQueryExecutions(
      request: ListQueryExecutionsRequest
  ): ZStream[zio.aws.athena.Athena, AwsError, QueryExecutionId] =
    ZStream.serviceWithStream(_.listQueryExecutions(request))
  def listQueryExecutionsPaginated(request: ListQueryExecutionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueryExecutionsPaginated(request))
  def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DataCatalogSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataCatalogs(request))
  def listDataCatalogsPaginated(request: ListDataCatalogsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataCatalogsPaginated(request))
  def getNamedQuery(request: GetNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNamedQuery(request))
  def getNotebookMetadata(request: GetNotebookMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNotebookMetadata(request))
  def updateNamedQuery(request: UpdateNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNamedQuery(request))
  def listExecutors(
      request: ListExecutorsRequest
  ): ZIO[zio.aws.athena.Athena, AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ListExecutorsResponse.ReadOnly,
    zio.aws.athena.model.ExecutorsSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listExecutors(request))
  def listExecutorsPaginated(request: ListExecutorsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListExecutorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExecutorsPaginated(request))
  def deletePreparedStatement(request: DeletePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePreparedStatement(request))
  def listEngineVersions(request: ListEngineVersionsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.EngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listEngineVersions(request))
  def listEngineVersionsPaginated(request: ListEngineVersionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEngineVersionsPaginated(request))
  def getQueryRuntimeStatistics(request: GetQueryRuntimeStatisticsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryRuntimeStatistics(request))
  def deleteNamedQuery(request: DeleteNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNamedQuery(request))
  def updateNotebookMetadata(request: UpdateNotebookMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateNotebookMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotebookMetadata(request))
  def getTableMetadata(request: GetTableMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTableMetadata(request))
  def batchGetNamedQuery(request: BatchGetNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetNamedQuery(request))
  def listApplicationDPUSizes(request: ListApplicationDpuSizesRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ApplicationDPUSizes.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationDPUSizes(request))
  def listApplicationDPUSizesPaginated(
      request: ListApplicationDpuSizesRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationDPUSizesPaginated(request))
  def createNamedQuery(request: CreateNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNamedQuery(request))
  def terminateSession(request: TerminateSessionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.TerminateSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateSession(request))
  def getDataCatalog(request: GetDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataCatalog(request))
  def deleteNotebook(request: DeleteNotebookRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteNotebookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNotebook(request))
  def createNotebook(request: CreateNotebookRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateNotebookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNotebook(request))
  def listCalculationExecutions(
      request: ListCalculationExecutionsRequest
  ): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CalculationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCalculationExecutions(request))
  def listCalculationExecutionsPaginated(
      request: ListCalculationExecutionsRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCalculationExecutionsPaginated(request))
  def getCapacityReservation(request: GetCapacityReservationRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCapacityReservation(request))
  def createCapacityReservation(request: CreateCapacityReservationRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCapacityReservation(request))
  def listWorkGroups(request: ListWorkGroupsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.WorkGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkGroups(request))
  def listWorkGroupsPaginated(request: ListWorkGroupsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkGroupsPaginated(request))
  def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.PreparedStatementSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPreparedStatements(request))
  def listPreparedStatementsPaginated(
      request: ListPreparedStatementsRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPreparedStatementsPaginated(request))
  def createPreparedStatement(request: CreatePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPreparedStatement(request))
  def deleteDataCatalog(request: DeleteDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataCatalog(request))
  def updateNotebook(request: UpdateNotebookRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateNotebookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotebook(request))
  def listCapacityReservations(
      request: ListCapacityReservationsRequest
  ): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CapacityReservation.ReadOnly
  ] = ZStream.serviceWithStream(_.listCapacityReservations(request))
  def listCapacityReservationsPaginated(
      request: ListCapacityReservationsRequest
  ): ZIO[zio.aws.athena.Athena, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listCapacityReservationsPaginated(request))
  def listNotebookMetadata(request: ListNotebookMetadataRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.NotebookMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotebookMetadata(request))
  def listNotebookMetadataPaginated(request: ListNotebookMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotebookMetadataPaginated(request))
  def createPresignedNotebookUrl(
      request: CreatePresignedNotebookUrlRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPresignedNotebookUrl(request))
  def getQueryExecution(request: GetQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryExecution(request))
  def updatePreparedStatement(request: UpdatePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePreparedStatement(request))
  def createDataCatalog(request: CreateDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataCatalog(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def exportNotebook(request: ExportNotebookRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ExportNotebookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportNotebook(request))
  def getSessionStatus(request: GetSessionStatusRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetSessionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSessionStatus(request))
  def listTableMetadata(request: ListTableMetadataRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.TableMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableMetadata(request))
  def listTableMetadataPaginated(request: ListTableMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTableMetadataPaginated(request))
  def cancelCapacityReservation(request: CancelCapacityReservationRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CancelCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelCapacityReservation(request))
  def startCalculationExecution(request: StartCalculationExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCalculationExecution(request))
  def updateCapacityReservation(request: UpdateCapacityReservationRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCapacityReservation(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getCapacityAssignmentConfiguration(
      request: GetCapacityAssignmentConfigurationRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetCapacityAssignmentConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCapacityAssignmentConfiguration(request))
  def startSession(request: StartSessionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StartSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSession(request))
  def listSessions(request: ListSessionsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.SessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSessions(request))
  def listSessionsPaginated(request: ListSessionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSessionsPaginated(request))
  def getCalculationExecutionCode(
      request: GetCalculationExecutionCodeRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCalculationExecutionCode(request))
  def listNamedQueries(
      request: ListNamedQueriesRequest
  ): ZStream[zio.aws.athena.Athena, AwsError, NamedQueryId] =
    ZStream.serviceWithStream(_.listNamedQueries(request))
  def listNamedQueriesPaginated(request: ListNamedQueriesRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNamedQueriesPaginated(request))
  def putCapacityAssignmentConfiguration(
      request: PutCapacityAssignmentConfigurationRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.PutCapacityAssignmentConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putCapacityAssignmentConfiguration(request))
  def deleteWorkGroup(request: DeleteWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkGroup(request))
  def getSession(request: GetSessionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSession(request))
  def importNotebook(request: ImportNotebookRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ImportNotebookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importNotebook(request))
  def getDatabase(request: GetDatabaseRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatabase(request))
  def getCalculationExecutionStatus(
      request: GetCalculationExecutionStatusRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCalculationExecutionStatus(request))
  def batchGetPreparedStatement(request: BatchGetPreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetPreparedStatement(request))
  def createWorkGroup(request: CreateWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkGroup(request))
  def getWorkGroup(request: GetWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkGroup(request))
  def batchGetQueryExecution(request: BatchGetQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetQueryExecution(request))
  def getCalculationExecution(request: GetCalculationExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCalculationExecution(request))
  def startQueryExecution(request: StartQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startQueryExecution(request))
  def getQueryResults(
      request: GetQueryResultsRequest
  ): ZIO[zio.aws.athena.Athena, AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ResultSetMetadata.ReadOnly,
    zio.aws.athena.model.Row.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getQueryResults(request))
  def getQueryResultsPaginated(request: GetQueryResultsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryResultsPaginated(request))
  def stopQueryExecution(request: StopQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopQueryExecution(request))
}
