package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TerminateSessionResponse(
    state: Optional[zio.aws.athena.model.SessionState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.TerminateSessionResponse = {
    import TerminateSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.TerminateSessionResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.TerminateSessionResponse.ReadOnly =
    zio.aws.athena.model.TerminateSessionResponse.wrap(buildAwsValue())
}
object TerminateSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.TerminateSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.TerminateSessionResponse =
      zio.aws.athena.model.TerminateSessionResponse(state.map(value => value))
    def state: Optional[zio.aws.athena.model.SessionState]
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.SessionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.TerminateSessionResponse
  ) extends zio.aws.athena.model.TerminateSessionResponse.ReadOnly {
    override val state: Optional[zio.aws.athena.model.SessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.athena.model.SessionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.TerminateSessionResponse
  ): zio.aws.athena.model.TerminateSessionResponse.ReadOnly = new Wrapper(impl)
}
