package zio.aws.athena.model
import zio.aws.athena.model.primitives.CalculationExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopCalculationExecutionRequest(
    calculationExecutionId: CalculationExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest = {
    import StopCalculationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest
      .builder()
      .calculationExecutionId(
        CalculationExecutionId.unwrap(calculationExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.StopCalculationExecutionRequest.ReadOnly =
    zio.aws.athena.model.StopCalculationExecutionRequest.wrap(buildAwsValue())
}
object StopCalculationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StopCalculationExecutionRequest =
      zio.aws.athena.model
        .StopCalculationExecutionRequest(calculationExecutionId)
    def calculationExecutionId: CalculationExecutionId
    def getCalculationExecutionId: ZIO[Any, Nothing, CalculationExecutionId] =
      ZIO.succeed(calculationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest
  ) extends zio.aws.athena.model.StopCalculationExecutionRequest.ReadOnly {
    override val calculationExecutionId: CalculationExecutionId =
      zio.aws.athena.model.primitives
        .CalculationExecutionId(impl.calculationExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest
  ): zio.aws.athena.model.StopCalculationExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
