package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryRuntimeStatisticsRows(
    inputRows: Optional[Long] = Optional.Absent,
    inputBytes: Optional[Long] = Optional.Absent,
    outputBytes: Optional[Long] = Optional.Absent,
    outputRows: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows = {
    import QueryRuntimeStatisticsRows.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows
      .builder()
      .optionallyWith(inputRows.map(value => value: java.lang.Long))(
        _.inputRows
      )
      .optionallyWith(inputBytes.map(value => value: java.lang.Long))(
        _.inputBytes
      )
      .optionallyWith(outputBytes.map(value => value: java.lang.Long))(
        _.outputBytes
      )
      .optionallyWith(outputRows.map(value => value: java.lang.Long))(
        _.outputRows
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly =
    zio.aws.athena.model.QueryRuntimeStatisticsRows.wrap(buildAwsValue())
}
object QueryRuntimeStatisticsRows {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryRuntimeStatisticsRows =
      zio.aws.athena.model.QueryRuntimeStatisticsRows(
        inputRows.map(value => value),
        inputBytes.map(value => value),
        outputBytes.map(value => value),
        outputRows.map(value => value)
      )
    def inputRows: Optional[Long]
    def inputBytes: Optional[Long]
    def outputBytes: Optional[Long]
    def outputRows: Optional[Long]
    def getInputRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inputRows", inputRows)
    def getInputBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inputBytes", inputBytes)
    def getOutputBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("outputBytes", outputBytes)
    def getOutputRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("outputRows", outputRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows
  ) extends zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly {
    override val inputRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inputRows())
      .map(value => value: Long)
    override val inputBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inputBytes())
      .map(value => value: Long)
    override val outputBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.outputBytes())
      .map(value => value: Long)
    override val outputRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.outputRows())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows
  ): zio.aws.athena.model.QueryRuntimeStatisticsRows.ReadOnly = new Wrapper(
    impl
  )
}
