package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueryRuntimeStatisticsResponse(
    queryRuntimeStatistics: Optional[
      zio.aws.athena.model.QueryRuntimeStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse = {
    import GetQueryRuntimeStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse
      .builder()
      .optionallyWith(
        queryRuntimeStatistics.map(value => value.buildAwsValue())
      )(_.queryRuntimeStatistics)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly =
    zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.wrap(buildAwsValue())
}
object GetQueryRuntimeStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryRuntimeStatisticsResponse =
      zio.aws.athena.model.GetQueryRuntimeStatisticsResponse(
        queryRuntimeStatistics.map(value => value.asEditable)
      )
    def queryRuntimeStatistics
        : Optional[zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly]
    def getQueryRuntimeStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "queryRuntimeStatistics",
      queryRuntimeStatistics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse
  ) extends zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly {
    override val queryRuntimeStatistics
        : Optional[zio.aws.athena.model.QueryRuntimeStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryRuntimeStatistics())
        .map(value => zio.aws.athena.model.QueryRuntimeStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse
  ): zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
