package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCapacityReservationRequest(name: CapacityReservationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest = {
    import GetCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest
      .builder()
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetCapacityReservationRequest.ReadOnly =
    zio.aws.athena.model.GetCapacityReservationRequest.wrap(buildAwsValue())
}
object GetCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCapacityReservationRequest =
      zio.aws.athena.model.GetCapacityReservationRequest(name)
    def name: CapacityReservationName
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest
  ) extends zio.aws.athena.model.GetCapacityReservationRequest.ReadOnly {
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest
  ): zio.aws.athena.model.GetCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
