package zio.aws.athena.model
import zio.aws.athena.model.primitives.NotebookName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterDefinition(
    name: Optional[NotebookName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.FilterDefinition = {
    import FilterDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.FilterDefinition
      .builder()
      .optionallyWith(
        name.map(value => NotebookName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.FilterDefinition.ReadOnly =
    zio.aws.athena.model.FilterDefinition.wrap(buildAwsValue())
}
object FilterDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.FilterDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.FilterDefinition =
      zio.aws.athena.model.FilterDefinition(name.map(value => value))
    def name: Optional[NotebookName]
    def getName: ZIO[Any, AwsError, NotebookName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.FilterDefinition
  ) extends zio.aws.athena.model.FilterDefinition.ReadOnly {
    override val name: Optional[NotebookName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.athena.model.primitives.NotebookName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.FilterDefinition
  ): zio.aws.athena.model.FilterDefinition.ReadOnly = new Wrapper(impl)
}
