package zio.aws.athena.model
import zio.aws.athena.model.primitives.CapacityReservationName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CapacityAssignmentConfiguration(
    capacityReservationName: Optional[CapacityReservationName] =
      Optional.Absent,
    capacityAssignments: Optional[
      Iterable[zio.aws.athena.model.CapacityAssignment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CapacityAssignmentConfiguration = {
    import CapacityAssignmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CapacityAssignmentConfiguration
      .builder()
      .optionallyWith(
        capacityReservationName.map(value =>
          CapacityReservationName.unwrap(value): java.lang.String
        )
      )(_.capacityReservationName)
      .optionallyWith(
        capacityAssignments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityAssignments)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.CapacityAssignmentConfiguration.ReadOnly =
    zio.aws.athena.model.CapacityAssignmentConfiguration.wrap(buildAwsValue())
}
object CapacityAssignmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CapacityAssignmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CapacityAssignmentConfiguration =
      zio.aws.athena.model.CapacityAssignmentConfiguration(
        capacityReservationName.map(value => value),
        capacityAssignments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationName: Optional[CapacityReservationName]
    def capacityAssignments
        : Optional[List[zio.aws.athena.model.CapacityAssignment.ReadOnly]]
    def getCapacityReservationName
        : ZIO[Any, AwsError, CapacityReservationName] = AwsError
      .unwrapOptionField("capacityReservationName", capacityReservationName)
    def getCapacityAssignments: ZIO[Any, AwsError, List[
      zio.aws.athena.model.CapacityAssignment.ReadOnly
    ]] = AwsError.unwrapOptionField("capacityAssignments", capacityAssignments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CapacityAssignmentConfiguration
  ) extends zio.aws.athena.model.CapacityAssignmentConfiguration.ReadOnly {
    override val capacityReservationName: Optional[CapacityReservationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationName())
        .map(value =>
          zio.aws.athena.model.primitives.CapacityReservationName(value)
        )
    override val capacityAssignments
        : Optional[List[zio.aws.athena.model.CapacityAssignment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityAssignments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.CapacityAssignment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CapacityAssignmentConfiguration
  ): zio.aws.athena.model.CapacityAssignmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
